/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security.support.expressiondsl.expressions;

import org.easysearch.client.security.support.expressiondsl.RoleMapperExpression;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;

/**
 * A negating expression. That is, this expression evaluates to <code>true</code> if-and-only-if
 * its delegate expression evaluate to <code>false</code>.
 * Syntactically, <em>except</em> expressions are intended to be children of <em>all</em>
 * expressions ({@link AllRoleMapperExpression}).
 */
public final class ExceptRoleMapperExpression extends CompositeRoleMapperExpression {

    public ExceptRoleMapperExpression(final RoleMapperExpression expression) {
        super(CompositeType.EXCEPT.getName(), expression);
    }

    @Override
    public XContentBuilder toXContent(final XContentBuilder builder, final Params params) throws IOException {
        builder.startObject();
        builder.field(CompositeType.EXCEPT.getName());
        builder.value(getElements().get(0));
        return builder.endObject();
    }

}
