/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security.user;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Set;

public class Account {
    @JsonProperty("username")
    private String username;

    @JsonProperty("reserved")
    private boolean reserved;

    @JsonProperty("hidden")
    private boolean hidden;

    @JsonProperty("builtin")
    private boolean builtin;

    @JsonProperty("external_roles")
    private List<String> externalRoles;

    @JsonProperty("attributes")
    private Set<String> attributes;

    @JsonProperty("roles")
    private List<String> roles;

    public Account(){

    }

    public String getUsername() {
        return username;
    }

    public Account setUsername(String username) {
        this.username = username;
        return this;
    }

    public boolean isReserved() {
        return reserved;
    }

    public Account setReserved(boolean reserved) {
        this.reserved = reserved;
        return this;
    }

    public boolean isHidden() {
        return hidden;
    }

    public Account setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public boolean isBuiltin() {
        return builtin;
    }

    public Account setBuiltin(boolean builtin) {
        this.builtin = builtin;
        return this;
    }

    public List<String> getExternalRoles() {
        return externalRoles;
    }

    public Account setExternalRoles(List<String> externalRoles) {
        this.externalRoles = externalRoles;
        return this;
    }

    public Set<String> getAttributes() {
        return attributes;
    }

    public Account setAttributes(Set<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public List<String> getRoles() {
        return roles;
    }

    public Account setRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }
}
