/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security.user;

import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import static org.easysearch.common.xcontent.ConstructingObjectParser.optionalConstructorArg;

public class Index implements ToXContentObject {
    private List<String> names;
    private List<String> field_security;
    private List<String> field_mask;
    private List<String> privileges;
    private String query;

    public Index() {
    }

    public Index(List<String> names,
                 List<String> field_security,
                 List<String> field_mask,
                 List<String> privileges,
                 String query) {
        this.names = names;
        this.field_security = field_security;
        this.field_mask = field_mask;
        this.privileges = privileges;
        this.query = query;
    }

    public Index names(String... name) {
        this.names = Arrays.asList(name);
        return this;
    }

    public Index field_security(String... field) {
        this.field_security = Arrays.asList(field);
        return this;
    }

    public Index field_mask(String... field) {
        this.field_mask = Arrays.asList(field);
        return this;
    }

    public Index privileges(String... privileges) {
        this.privileges = Arrays.asList(privileges);
        return this;
    }

    public Index query(String query) {
        this.query = query;
        return this;
    }


    public List<String> getNames() {
        return names;
    }

    public List<String> getField_security() {
        return field_security;
    }

    public List<String> getField_mask() {
        return field_mask;
    }

    public List<String> getPrivileges() {
        return privileges;
    }

    public String getQuery() {
        return query;
    }

    @SuppressWarnings("unchecked")
    static final ConstructingObjectParser<Index, Void> PARSER = new ConstructingObjectParser<>(
        "index", false, constructorObjects -> {
        int i = 0;
        final List<String> names = (List<String>) constructorObjects[i++];
        final List<String> field_security = (List<String>) constructorObjects[i++];
        final List<String> field_mask = (List<String>) constructorObjects[i++];
        final List<String> privileges = (List<String>) constructorObjects[i++];
        final String query = (String) constructorObjects[i];
        return new Index(names, field_security, field_mask, privileges, query);
    }
    );

    static {
        PARSER.declareStringArray(optionalConstructorArg(), new ParseField("names"));
        PARSER.declareStringArray(optionalConstructorArg(), new ParseField("field_security"));
        PARSER.declareStringArray(optionalConstructorArg(), new ParseField("field_mask"));
        PARSER.declareStringArray(optionalConstructorArg(), new ParseField("privileges"));
        PARSER.declareString(optionalConstructorArg(), new ParseField("query"));
    }

    public static Index fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        builder.startObject();
        if (names != null) {
            builder.field("names", names);
        }
        if (field_security != null) {
            builder.field("field_security", field_security);
        }
        if (field_mask != null) {
            builder.field("field_mask", field_mask);
        }
        if (privileges != null) {
            builder.field("privileges", privileges);
        }
        if (query != null) {
            builder.field("query", query);
        }
        return builder.endObject();
    }
}
