/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

public class Role {

    @JsonIgnore
    private String name;
    private final boolean reserved;
    private final boolean hidden;
    @JsonProperty(value = "static")
    private final boolean _static;
    private final List<String> cluster;
    private final List<Index> indices;
    private final String description;


    /**
     * @param cluster
     * @param indices
     * @param description
     */
    public Role(String name, List<String> cluster, List<Index> indices, String description) {
        this(false, false, false, name, cluster, indices, description);
    }

    public Role(boolean reserved, boolean hidden, boolean _static, String name, List<String> cluster, List<Index> indices, String description) {
        this.reserved = reserved;
        this.hidden = hidden;
        this._static = _static;
        this.name = name;
        this.cluster = cluster;
        this.indices = indices;
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public boolean isReserved() {
        return reserved;
    }

    public boolean isHidden() {
        return hidden;
    }

    public boolean is_static() {
        return _static;
    }

    public List<String> getCluster() {
        return cluster;
    }

    public List<Index> getIndices() {
        return indices;
    }

    public String getDescription() {
        return description;
    }

}
