package org.easysearch.client.security.user;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.Collections;
import java.util.List;

public class RoleMapping {

    @JsonIgnore
    private String name;
    private boolean reserved;
    private boolean hidden;
    private List<String> external_roles = Collections.emptyList();
    private List<String> and_external_roles = Collections.emptyList();
    private String description;
    private List<String> hosts = Collections.emptyList();
    private List<String> users = Collections.emptyList();

    public RoleMapping(String name, List<String> external_roles, List<String> hosts, List<String> users, String description) {
        this(name, external_roles, Collections.emptyList(), description, hosts, users, false, false);
    }


    public RoleMapping(String name, List<String> external_roles,
                       List<String> and_external_roles, String description,
                       List<String> hosts, List<String> users) {
        this(name, external_roles, and_external_roles, description, hosts, users, false, false);
    }


    public RoleMapping(String name, List<String> external_roles,
                       List<String> and_external_roles, String description,
                       List<String> hosts, List<String> users, boolean reserved, boolean hidden) {
        this.name = name;
        this.external_roles = external_roles;
        this.and_external_roles = and_external_roles;
        this.description = description;
        this.hosts = hosts;
        this.users = users;
        this.reserved = reserved;
        this.hidden = hidden;
    }

    public boolean isReserved() {
        return reserved;
    }

    public boolean isHidden() {
        return hidden;
    }

    public List<String> getExternal_roles() {
        return external_roles;
    }

    public List<String> getAnd_external_roles() {
        return and_external_roles;
    }

    public String getDescription() {
        return description;
    }

    public List<String> getHosts() {
        return hosts;
    }

    public List<String> getUsers() {
        return users;
    }

    public String getName() {
        return name;
    }
}
