package org.easysearch.client.security.user.parser;

import org.easysearch.client.security.user.privileges.Privilege;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParserUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PrivilegeJsonParser {
    public static Set<Privilege> parsePrivileges(XContentParser jsonParser) throws IOException, IllegalArgumentException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, jsonParser.nextToken(), jsonParser);
        Set<Privilege> privileges = new HashSet<>();
        XContentParser.Token token;
        while ((token = jsonParser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, jsonParser);

            String name = jsonParser.currentName();
            jsonParser.nextToken();

            List<String> actions = new ArrayList<>();

            boolean reserved = false;
            boolean hidden = false;
            boolean _static = false;
            String description = null;
            String type = null;
            while (jsonParser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = jsonParser.currentName();
                jsonParser.nextToken();

                switch (fieldName) {
                    case "privileges":
                        actions = parseStringArray(jsonParser);
                        break;
                    case "reserved":
                        reserved = jsonParser.booleanValue();
                        break;
                    case "hidden":
                        hidden = jsonParser.booleanValue();
                        break;
                    case "static":
                        _static = jsonParser.booleanValue();
                        break;
                    case "description":
                        description = jsonParser.text();
                    case "type":
                        type = jsonParser.text();
                        break;
                    default:
                        //logger.warn("Unexpected field '{}' encountered", fieldName);
                        break;
                }
            }

            Privilege privilege = new Privilege(name, reserved, hidden, _static, actions, type, description);
            privileges.add(privilege);
        }
        return privileges;
    }

    private static List<String> parseStringArray(XContentParser jsonParser) throws IOException {
        List<String> stringList = new ArrayList<>();
        while (jsonParser.nextToken() != XContentParser.Token.END_ARRAY) {
            stringList.add(jsonParser.text());
        }
        return stringList;
    }
}
