package org.easysearch.client.security.user.parser;

import org.easysearch.client.security.user.RoleMapping;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParserUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RoleMappingJsonParser {
    public static Set<RoleMapping> parseRoleMappings(XContentParser jsonParser) throws IOException, IllegalArgumentException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, jsonParser.nextToken(), jsonParser);
        Set<RoleMapping> roleMappings = new HashSet<>();
        XContentParser.Token token;
        while ((token = jsonParser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, jsonParser);

            String name = jsonParser.currentName();
            jsonParser.nextToken();

            List<String> external_roles = new ArrayList<>();
            List<String> and_external_roles = new ArrayList<>();
            List<String> hosts = new ArrayList<>();
            List<String> users = new ArrayList<>();

            boolean reserved = false;
            boolean hidden = false;
            String description = null;
            while (jsonParser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = jsonParser.currentName();
                jsonParser.nextToken();

                switch (fieldName) {
                    case "external_roles":
                        external_roles = parseStringArray(jsonParser);
                        break;
                    case "and_external_roles":
                        and_external_roles = parseStringArray(jsonParser);
                        break;
                    case "hosts":
                        hosts = parseStringArray(jsonParser);
                        break;
                    case "users":
                        users = parseStringArray(jsonParser);
                        break;
                    case "reserved":
                        reserved = jsonParser.booleanValue();
                        break;
                    case "hidden":
                        hidden = jsonParser.booleanValue();
                        break;
                    case "description":
                        description = jsonParser.text();
                    default:
                        //logger.warn("Unexpected field '{}' encountered", fieldName);
                        break;
                }
            }

            RoleMapping roleMapping = new RoleMapping(name, external_roles, and_external_roles, description, hosts, users, reserved, hidden);
            roleMappings.add(roleMapping);
        }
        return roleMappings;
    }

    private static List<String> parseStringArray(XContentParser jsonParser) throws IOException {
        List<String> stringList = new ArrayList<>();
        while (jsonParser.nextToken() != XContentParser.Token.END_ARRAY) {
            stringList.add(jsonParser.text());
        }
        return stringList;
    }
}
