/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security.user.parser;

import org.easysearch.client.security.user.User;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParser.Token;
import org.easysearch.common.xcontent.XContentParserUtils;

import java.io.IOException;
import java.util.*;

public class UserJsonParser {
    //private static final Logger logger = LoggerFactory.getLogger(UserJsonParser.class);

    public static Set<User> parseUsers(XContentParser jsonParser) throws IOException, IllegalArgumentException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, jsonParser.nextToken(), jsonParser);
        Set<User> users = new HashSet<>();
        XContentParser.Token token;
        while ((token = jsonParser.nextToken()) != Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(Token.FIELD_NAME, token, jsonParser);

            String username = jsonParser.currentName();
            jsonParser.nextToken();

            String hash = "";
            List<String> roles = new ArrayList<>();
            List<String> externalRoles = new ArrayList<>();
            Map<String, Object> attributes = new HashMap<>();
            boolean reserved = false;
            boolean hidden = false;
            boolean isStatic = false;

            while (jsonParser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = jsonParser.currentName();
                jsonParser.nextToken();

                switch (fieldName) {
                    case "hash":
                        hash = jsonParser.text();
                        break;
                    case "roles":
                        roles = parseStringArray(jsonParser);
                        break;
                    case "external_roles":
                        externalRoles = parseStringArray(jsonParser);
                        break;
                    case "attributes":
                        attributes = parseAttributes(jsonParser);
                        break;
                    case "reserved":
                        reserved = jsonParser.booleanValue();
                        break;
                    case "hidden":
                        hidden = jsonParser.booleanValue();
                        break;
                    case "static":
                        isStatic = jsonParser.booleanValue();
                        break;
                    default:
                        //logger.warn("Unexpected field '{}' encountered", fieldName);
                        break;
                }
            }

            User user = new User(username, hash, roles, externalRoles, attributes, reserved, hidden, isStatic);
            users.add(user);
        }
        return users;
    }

    private static List<String> parseStringArray(XContentParser jsonParser) throws IOException {
        List<String> stringList = new ArrayList<>();
        while (jsonParser.nextToken() != Token.END_ARRAY) {
            stringList.add(jsonParser.text());
        }
        return stringList;
    }

    private static Map<String, Object> parseAttributes(XContentParser jsonParser) throws IOException {
        Map<String, Object> attributes = new HashMap<>();
        while (jsonParser.nextToken() != Token.END_OBJECT) {
            String key = jsonParser.currentName();
            jsonParser.nextToken();
            attributes.put(key, jsonParser.text());
        }
        return attributes;
    }



}
