package org.easysearch.client.security.user.privileges;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.*;

public class Privilege {

    @JsonIgnore
    private String name;
    private boolean reserved;
    private boolean hidden;
    private Set<String> privileges;
    private String type;
    private String description;
    @JsonProperty("static")
    private boolean _static;

    public Privilege(String name, Collection<String> privileges, String description) {
        this(name, false, false, false, privileges, null, description);
    }

    public Privilege(String name, boolean reserved, boolean hidden, boolean _static, Collection<String> privileges, String type, String description) {
        this.name = name;
        this.reserved = reserved;
        this.hidden = hidden;
        if (privileges == null || privileges.isEmpty()) {
            throw new IllegalArgumentException("privileges must be provided");
        } else {
            this.privileges = Collections.unmodifiableSet(new HashSet<>(privileges));
        }

        this._static = _static;
    }

    public String getName() {
        return name;
    }

    public boolean isReserved() {
        return reserved;
    }


    public boolean isHidden() {
        return hidden;
    }


    public Set<String> getPrivileges() {
        return privileges;
    }


    public String getType() {
        return type;
    }


    public String getDescription() {
        return description;
    }


    public boolean is_static() {
        return _static;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Privilege p = (Privilege) o;
        return reserved == p.reserved && hidden == p.hidden
            && _static == p._static && name.equals(p.name)
            && Objects.equals(privileges, p.privileges)
            && Objects.equals(description, p.description)
            && Objects.equals(type, p.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, reserved, hidden, _static, privileges, description, type);
    }
}
