/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.slm;

import org.easysearch.client.TimedRequest;

import java.util.Objects;

public class ExecuteSnapshotLifecyclePolicyRequest extends TimedRequest {
    private final String policyId;

    public ExecuteSnapshotLifecyclePolicyRequest(String policyId) {
        this.policyId = policyId;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExecuteSnapshotLifecyclePolicyRequest other = (ExecuteSnapshotLifecyclePolicyRequest) o;
        return this.policyId.equals(other.policyId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policyId);
    }
}
