/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.slm;

import org.easysearch.client.TimedRequest;

import java.util.Arrays;

public class GetSnapshotLifecyclePolicyRequest extends TimedRequest {
    private final String[] policyIds;

    public GetSnapshotLifecyclePolicyRequest(String... ids) {
        this.policyIds = ids;
    }

    public String[] getPolicyIds() {
        return this.policyIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetSnapshotLifecyclePolicyRequest other = (GetSnapshotLifecyclePolicyRequest) o;
        return Arrays.equals(this.policyIds, other.policyIds);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.policyIds);
    }
}
