/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.slm;

import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import static org.easysearch.common.xcontent.XContentParserUtils.ensureExpectedToken;

public class GetSnapshotLifecyclePolicyResponse implements ToXContentObject {

    private final Map<String, SnapshotLifecyclePolicyMetadata> policies;

    public GetSnapshotLifecyclePolicyResponse(Map<String, SnapshotLifecyclePolicyMetadata> policies) {
        this.policies = policies;
    }

    public Map<String, SnapshotLifecyclePolicyMetadata> getPolicies() {
        return this.policies;
    }

    public static GetSnapshotLifecyclePolicyResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        parser.nextToken();

        Map<String, SnapshotLifecyclePolicyMetadata> policies = new HashMap<>();
        while (parser.isClosed() == false) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                final String policyId = parser.currentName();
                SnapshotLifecyclePolicyMetadata policyDefinition = SnapshotLifecyclePolicyMetadata.parse(parser, policyId);
                policies.put(policyId, policyDefinition);
            } else {
                parser.nextToken();
            }
        }
        return new GetSnapshotLifecyclePolicyResponse(policies);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        return builder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        GetSnapshotLifecyclePolicyResponse other = (GetSnapshotLifecyclePolicyResponse) o;
        return Objects.equals(this.policies, other.policies);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policies);
    }
}
