/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.slm;

import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Objects;

public class GetSnapshotLifecycleStatsResponse implements ToXContentObject {

    private final SnapshotLifecycleStats stats;

    public GetSnapshotLifecycleStatsResponse(SnapshotLifecycleStats stats) {
        this.stats = stats;
    }

    public SnapshotLifecycleStats getStats() {
        return this.stats;
    }

    public static GetSnapshotLifecycleStatsResponse fromXContent(XContentParser parser) throws IOException {
        return new GetSnapshotLifecycleStatsResponse(SnapshotLifecycleStats.parse(parser));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        return stats.toXContent(builder, params);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        GetSnapshotLifecycleStatsResponse other = (GetSnapshotLifecycleStatsResponse) o;
        return Objects.equals(this.stats, other.stats);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stats);
    }
}
