/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.slm;

import org.easysearch.client.TimedRequest;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.Objects;

public class PutSnapshotLifecyclePolicyRequest extends TimedRequest implements ToXContentObject {

    private final SnapshotLifecyclePolicy policy;

    public PutSnapshotLifecyclePolicyRequest(SnapshotLifecyclePolicy policy) {
        this.policy = Objects.requireNonNull(policy, "policy definition cannot be null");
    }

    public SnapshotLifecyclePolicy getPolicy() {
        return policy;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        policy.toXContent(builder, params);
        return builder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PutSnapshotLifecyclePolicyRequest other = (PutSnapshotLifecyclePolicyRequest) o;
        return Objects.equals(this.policy, other.policy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policy);
    }
}
