/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.tasks;

import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.List;

import static org.easysearch.common.xcontent.ConstructingObjectParser.optionalConstructorArg;

/**
 * cancel tasks response that contains
 * - task failures
 * - node failures
 * - tasks
 */
public class CancelTasksResponse extends ListTasksResponse {

    CancelTasksResponse(List<NodeData> nodesInfoData,
                        List<TaskOperationFailure> taskFailures,
                        List<EasysearchException> nodeFailures) {
        super(nodesInfoData, taskFailures, nodeFailures);
    }

    public static CancelTasksResponse fromXContent(final XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private static ConstructingObjectParser<CancelTasksResponse, Void> PARSER;

    static {
        ConstructingObjectParser<CancelTasksResponse, Void> parser = new ConstructingObjectParser<>("cancel_tasks_response", true,
            constructingObjects -> {
                int i = 0;
                @SuppressWarnings("unchecked")
                List<TaskOperationFailure> tasksFailures = (List<TaskOperationFailure>) constructingObjects[i++];
                @SuppressWarnings("unchecked")
                List<EasysearchException> nodeFailures = (List<EasysearchException>) constructingObjects[i++];
                @SuppressWarnings("unchecked")
                List<NodeData> nodesInfoData = (List<NodeData>) constructingObjects[i];
                return new CancelTasksResponse(nodesInfoData, tasksFailures, nodeFailures);
            });

        parser.declareObjectArray(optionalConstructorArg(), (p, c) ->
            TaskOperationFailure.fromXContent(p), new ParseField("task_failures"));
        parser.declareObjectArray(optionalConstructorArg(), (p, c) ->
            EasysearchException.fromXContent(p), new ParseField("node_failures"));
        parser.declareNamedObjects(optionalConstructorArg(), NodeData.PARSER, new ParseField("nodes"));
        PARSER = parser;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "CancelTasksResponse{" +
            "taskFailures=" + taskFailures +
            ", nodeFailures=" + nodeFailures +
            ", nodesInfoData=" + nodesInfoData +
            ", tasks=" + tasks +
            ", taskGroups=" + taskGroups +
            '}';
    }
}
