/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.tasks;

import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.tasks.TaskInfo;

import static org.easysearch.common.xcontent.ConstructingObjectParser.constructorArg;

public class GetTaskResponse {
    private final boolean completed;
    private final TaskInfo taskInfo;
    public static final ParseField COMPLETED = new ParseField("completed");
    public static final ParseField TASK = new ParseField("task");

    public GetTaskResponse(boolean completed, TaskInfo taskInfo) {
        this.completed = completed;
        this.taskInfo = taskInfo;
    }

    public boolean isCompleted() {
        return completed;
    }

    public TaskInfo getTaskInfo() {
        return taskInfo;
    }

    private static final ConstructingObjectParser<GetTaskResponse, Void> PARSER = new ConstructingObjectParser<>("get_task",
            true, a -> new GetTaskResponse((boolean) a[0],  (TaskInfo) a[1]));
    static {
        PARSER.declareBoolean(constructorArg(), COMPLETED);
        PARSER.declareObject(constructorArg(), (p, c) -> TaskInfo.fromXContent(p), TASK);
    }

    public static GetTaskResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }
}
