/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.watcher;

import org.easysearch.client.Validatable;

import java.util.Objects;

/**
 * A request to explicitly activate a watch.
 */
public final class ActivateWatchRequest implements Validatable {

    private final String watchId;

    public ActivateWatchRequest(String watchId) {
        this.watchId  = Objects.requireNonNull(watchId, "Watch identifier is required");
        if (PutWatchRequest.isValidId(this.watchId) == false) {
            throw new IllegalArgumentException("Watch identifier contains whitespace");
        }
    }

    /**
     * @return The ID of the watch to be activated.
     */
    public String getWatchId() {
        return watchId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ActivateWatchRequest that = (ActivateWatchRequest) o;
        return Objects.equals(watchId, that.watchId);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(watchId);
        return result;
    }
}
