/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.watcher;

import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Objects;

/**
 * Response from an 'activate watch' request.
 */
public final class ActivateWatchResponse {

    private static final ParseField STATUS_FIELD = new ParseField("status");
    private static final ConstructingObjectParser<ActivateWatchResponse, Void> PARSER =
        new ConstructingObjectParser<>("activate_watch_response", true,
            a -> new ActivateWatchResponse((WatchStatus) a[0]));

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(),
            (parser, context) -> WatchStatus.parse(parser),
            STATUS_FIELD);
    }

    private final WatchStatus status;

    public ActivateWatchResponse(WatchStatus status) {
        this.status = status;
    }

    public WatchStatus getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ActivateWatchResponse that = (ActivateWatchResponse) o;
        return Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status);
    }

    public static ActivateWatchResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }
}
