/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.watcher;

import org.easysearch.client.Validatable;
import org.easysearch.client.watcher.PutWatchRequest;

import java.util.Objects;

public class DeactivateWatchRequest implements Validatable {
    private final String watchId;

    public DeactivateWatchRequest(String watchId) {
        Objects.requireNonNull(watchId, "watch id is missing");
        if (PutWatchRequest.isValidId(watchId) == false) {
            throw new IllegalArgumentException("watch id contains whitespace");
        }

        this.watchId = watchId;
    }

    public String getWatchId() {
        return watchId;
    }
}

