/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.watcher;

import org.easysearch.client.Validatable;

import java.util.Objects;

/**
 * A delete watch request to delete an watch by name (id)
 */
public class DeleteWatchRequest implements Validatable {

    private final String id;

    public DeleteWatchRequest(String id) {
        Objects.requireNonNull(id, "watch id is missing");
        if (PutWatchRequest.isValidId(id) == false) {
            throw new IllegalArgumentException("watch id contains whitespace");
        }
        this.id = id;
    }

    /**
     * @return The name of the watch to be deleted
     */
    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        return "delete [" + id + "]";
    }
}
