/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.watcher;

import org.easysearch.client.Validatable;
import org.easysearch.client.ValidationException;

/**
 * The request to get the watch by name (id)
 */
public final class GetWatchRequest implements Validatable {

    private final String id;

    public GetWatchRequest(String watchId) {
        validateId(watchId);
        this.id = watchId;
    }

    private void validateId(String id) {
        ValidationException exception = new ValidationException();
        if (id == null) {
            exception.addValidationError("watch id is missing");
        } else if (PutWatchRequest.isValidId(id) == false) {
            exception.addValidationError("watch id contains whitespace");
        }
        if (exception.validationErrors().isEmpty() == false) {
            throw exception;
        }
    }

    /**
     * @return The name of the watch to retrieve
     */
    public String getId() {
        return id;
    }
}
