/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.watcher;

import org.easysearch.client.Validatable;

/**
 * A request to explicitly acknowledge a watch.
 */
public class WatcherStatsRequest implements Validatable {

    private final boolean includeCurrentWatches;
    private final boolean includeQueuedWatches;

    public WatcherStatsRequest( ) {
        this(true, true);
    }

    public WatcherStatsRequest(boolean includeCurrentWatches, boolean includeQueuedWatches) {
        this.includeCurrentWatches = includeCurrentWatches;
        this.includeQueuedWatches = includeQueuedWatches;
    }

    public boolean includeCurrentWatches() {
        return includeCurrentWatches;
    }

    public boolean includeQueuedWatches() {
        return includeQueuedWatches;
    }

    @Override
    public String toString() {
        return "stats [current=" + includeCurrentWatches + ", " + "queued=" + includeQueuedWatches + "]";
    }
}
