/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action;

import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionListenerResponseHandler;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.ActionResponse;
import org.easysearch.action.ActionType;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.settings.Settings;
import org.easysearch.transport.TransportRequest;
import org.easysearch.transport.TransportRequestOptions;
import org.easysearch.transport.TransportService;

public class TransportActionNodeProxy<Request extends ActionRequest, Response extends ActionResponse> {
    private final TransportService transportService;
    private final ActionType<Response> action;
    private final TransportRequestOptions transportOptions;

    public TransportActionNodeProxy(Settings settings, ActionType<Response> action, TransportService transportService) {
        this.action = action;
        this.transportService = transportService;
        this.transportOptions = action.transportOptions(settings);
    }

    public void execute(DiscoveryNode node, Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException = ((ActionRequest)request).validate();
        if (validationException != null) {
            listener.onFailure(validationException);
            return;
        }
        this.transportService.sendRequest(node, this.action.name(), (TransportRequest)request, this.transportOptions, new ActionListenerResponseHandler<Response>(listener, this.action.getResponseReader()));
    }
}

