/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.AlreadyClosedException;
import org.easysearch.action.FailedNodeException;
import org.easysearch.action.admin.cluster.node.info.NodeInfo;
import org.easysearch.action.admin.cluster.node.stats.NodeStats;
import org.easysearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.easysearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.easysearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.easysearch.action.admin.indices.stats.CommonStats;
import org.easysearch.action.admin.indices.stats.CommonStatsFlags;
import org.easysearch.action.admin.indices.stats.ShardStats;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.nodes.BaseNodeRequest;
import org.easysearch.action.support.nodes.TransportNodesAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.health.ClusterHealthStatus;
import org.easysearch.cluster.health.ClusterStateHealth;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.IndexService;
import org.easysearch.index.engine.CommitStats;
import org.easysearch.index.seqno.RetentionLeaseStats;
import org.easysearch.index.seqno.SeqNoStats;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.indices.IndicesService;
import org.easysearch.node.NodeService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;
import org.easysearch.transport.Transports;

public class TransportClusterStatsAction
extends TransportNodesAction<ClusterStatsRequest, ClusterStatsResponse, ClusterStatsNodeRequest, ClusterStatsNodeResponse> {
    private static final CommonStatsFlags SHARD_STATS_FLAGS = new CommonStatsFlags(CommonStatsFlags.Flag.Docs, CommonStatsFlags.Flag.Store, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.Completion, CommonStatsFlags.Flag.Segments);
    private final NodeService nodeService;
    private final IndicesService indicesService;

    @Inject
    public TransportClusterStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, IndicesService indicesService, ActionFilters actionFilters) {
        super("cluster:monitor/stats", threadPool, clusterService, transportService, actionFilters, ClusterStatsRequest::new, ClusterStatsNodeRequest::new, "management", "management", ClusterStatsNodeResponse.class);
        this.nodeService = nodeService;
        this.indicesService = indicesService;
    }

    @Override
    protected ClusterStatsResponse newResponse(ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures) {
        assert (Transports.assertNotTransportThread("Constructor of ClusterStatsResponse runs expensive computations on mappings found in the cluster state that are too slow for a transport thread"));
        ClusterState state = this.clusterService.state();
        return new ClusterStatsResponse(System.currentTimeMillis(), state.metadata().clusterUUID(), this.clusterService.getClusterName(), responses, failures, state);
    }

    @Override
    protected ClusterStatsNodeRequest newNodeRequest(ClusterStatsRequest request) {
        return new ClusterStatsNodeRequest(request);
    }

    @Override
    protected ClusterStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    protected ClusterStatsNodeResponse nodeOperation(ClusterStatsNodeRequest nodeRequest) {
        NodeInfo nodeInfo = this.nodeService.info(true, true, false, true, false, true, false, true, false, false, false);
        NodeStats nodeStats = this.nodeService.stats(CommonStatsFlags.NONE, true, true, true, false, true, false, false, false, false, false, true, false, false, false);
        ArrayList<ShardStats> shardsStats = new ArrayList<ShardStats>();
        for (IndexService indexService : this.indicesService) {
            for (IndexShard indexShard : indexService) {
                RetentionLeaseStats retentionLeaseStats;
                SeqNoStats seqNoStats;
                CommitStats commitStats;
                if (indexShard.routingEntry() == null || !indexShard.routingEntry().active()) continue;
                try {
                    commitStats = indexShard.commitStats();
                    seqNoStats = indexShard.seqNoStats();
                    retentionLeaseStats = indexShard.getRetentionLeaseStats();
                }
                catch (AlreadyClosedException e) {
                    commitStats = null;
                    seqNoStats = null;
                    retentionLeaseStats = null;
                }
                shardsStats.add(new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(this.indicesService.getIndicesQueryCache(), indexShard, SHARD_STATS_FLAGS), commitStats, seqNoStats, retentionLeaseStats));
            }
        }
        ClusterHealthStatus clusterStatus = null;
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            clusterStatus = new ClusterStateHealth(this.clusterService.state()).getStatus();
        }
        return new ClusterStatsNodeResponse(nodeInfo.getNode(), clusterStatus, nodeInfo, nodeStats, shardsStats.toArray(new ShardStats[shardsStats.size()]));
    }

    public static class ClusterStatsNodeRequest
    extends BaseNodeRequest {
        ClusterStatsRequest request;

        public ClusterStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new ClusterStatsRequest(in);
        }

        ClusterStatsNodeRequest(ClusterStatsRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

