/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.dangling.find;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.easysearch.action.FailedNodeException;
import org.easysearch.action.admin.indices.dangling.find.FindDanglingIndexRequest;
import org.easysearch.action.admin.indices.dangling.find.FindDanglingIndexResponse;
import org.easysearch.action.admin.indices.dangling.find.NodeFindDanglingIndexRequest;
import org.easysearch.action.admin.indices.dangling.find.NodeFindDanglingIndexResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.nodes.TransportNodesAction;
import org.easysearch.cluster.metadata.IndexMetadata;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.gateway.DanglingIndicesState;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportFindDanglingIndexAction
extends TransportNodesAction<FindDanglingIndexRequest, FindDanglingIndexResponse, NodeFindDanglingIndexRequest, NodeFindDanglingIndexResponse> {
    private final TransportService transportService;
    private final DanglingIndicesState danglingIndicesState;

    @Inject
    public TransportFindDanglingIndexAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, DanglingIndicesState danglingIndicesState) {
        super("cluster:admin/indices/dangling/find", threadPool, clusterService, transportService, actionFilters, FindDanglingIndexRequest::new, NodeFindDanglingIndexRequest::new, "management", NodeFindDanglingIndexResponse.class);
        this.transportService = transportService;
        this.danglingIndicesState = danglingIndicesState;
    }

    @Override
    protected FindDanglingIndexResponse newResponse(FindDanglingIndexRequest request, List<NodeFindDanglingIndexResponse> nodeResponses, List<FailedNodeException> failures) {
        return new FindDanglingIndexResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    @Override
    protected NodeFindDanglingIndexRequest newNodeRequest(FindDanglingIndexRequest request) {
        return new NodeFindDanglingIndexRequest(request.getIndexUUID());
    }

    @Override
    protected NodeFindDanglingIndexResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodeFindDanglingIndexResponse(in);
    }

    @Override
    protected NodeFindDanglingIndexResponse nodeOperation(NodeFindDanglingIndexRequest request) {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        String indexUUID = request.getIndexUUID();
        ArrayList<IndexMetadata> danglingIndexInfo = new ArrayList<IndexMetadata>();
        for (IndexMetadata each : this.danglingIndicesState.getDanglingIndices().values()) {
            if (!each.getIndexUUID().equals(indexUUID)) continue;
            danglingIndexInfo.add(each);
        }
        return new NodeFindDanglingIndexResponse(localNode, danglingIndexInfo);
    }
}

