/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.diskusage;

import java.io.IOException;
import java.util.Map;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.ValidateActions;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.broadcast.BroadcastRequest;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.tasks.CancellableTask;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;

public class AnalyzeIndexSpaceUsageRequest
extends BroadcastRequest<AnalyzeIndexSpaceUsageRequest> {
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, false, true);
    final boolean flush;

    public AnalyzeIndexSpaceUsageRequest(String[] indices, IndicesOptions indicesOptions, boolean flush) {
        super(indices, indicesOptions);
        this.flush = flush;
    }

    public AnalyzeIndexSpaceUsageRequest(StreamInput in) throws IOException {
        super(in);
        this.flush = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.flush);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationError = super.validate();
        if (this.indices.length == 0) {
            validationError = ValidateActions.addValidationError("indices must be specified for disk usage request", validationError);
        }
        return validationError;
    }

    @Override
    public void setParentTask(String parentTaskNode, long parentTaskId) {
        super.setParentTask(parentTaskNode, parentTaskId);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, "indices:admin/analyze_space_usage", type, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return AnalyzeIndexSpaceUsageRequest.this.getDescription();
            }
        };
    }

    @Override
    public String getDescription() {
        return "analyze disk usage indices [" + String.join((CharSequence)",", this.indices) + "], flush [" + this.flush + "]";
    }
}

