/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.ValidateActions;
import org.easysearch.action.admin.indices.create.CreateIndexRequest;
import org.easysearch.action.admin.indices.rollover.Condition;
import org.easysearch.action.admin.indices.rollover.MaxAgeCondition;
import org.easysearch.action.admin.indices.rollover.MaxDocsCondition;
import org.easysearch.action.admin.indices.rollover.MaxSizeCondition;
import org.easysearch.action.support.ActiveShardCount;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.master.AcknowledgedRequest;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.unit.ByteSizeValue;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.mapper.MapperService;

public class RolloverRequest
extends AcknowledgedRequest<RolloverRequest>
implements IndicesRequest,
ToXContentObject {
    private static final ObjectParser<RolloverRequest, Boolean> PARSER = new ObjectParser("rollover");
    private static final ObjectParser<Map<String, Condition<?>>, Void> CONDITION_PARSER = new ObjectParser("conditions");
    private static final ParseField CONDITIONS = new ParseField("conditions", new String[0]);
    private static final ParseField MAX_AGE_CONDITION = new ParseField("max_age", new String[0]);
    private static final ParseField MAX_DOCS_CONDITION = new ParseField("max_docs", new String[0]);
    private static final ParseField MAX_SIZE_CONDITION = new ParseField("max_size", new String[0]);
    private String rolloverTarget;
    private String newIndexName;
    private boolean dryRun;
    private final Map<String, Condition<?>> conditions = new HashMap(2);
    private CreateIndexRequest createIndexRequest = new CreateIndexRequest("_na_");

    public RolloverRequest(StreamInput in) throws IOException {
        super(in);
        this.rolloverTarget = in.readString();
        this.newIndexName = in.readOptionalString();
        this.dryRun = in.readBoolean();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            Condition condition = in.readNamedWriteable(Condition.class);
            this.conditions.put(condition.name, condition);
        }
        this.createIndexRequest = new CreateIndexRequest(in);
    }

    RolloverRequest() {
    }

    public RolloverRequest(String rolloverTarget, String newIndexName) {
        this.rolloverTarget = rolloverTarget;
        this.newIndexName = newIndexName;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = this.createIndexRequest.validate();
        if (this.rolloverTarget == null) {
            validationException = ValidateActions.addValidationError("rollover target is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.rolloverTarget);
        out.writeOptionalString(this.newIndexName);
        out.writeBoolean(this.dryRun);
        out.writeVInt(this.conditions.size());
        for (Condition<?> condition : this.conditions.values()) {
            if (!condition.includedInVersion(out.getVersion())) continue;
            out.writeNamedWriteable(condition);
        }
        this.createIndexRequest.writeTo(out);
    }

    @Override
    public String[] indices() {
        return new String[]{this.rolloverTarget};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public void setRolloverTarget(String rolloverTarget) {
        this.rolloverTarget = rolloverTarget;
    }

    public void setNewIndexName(String newIndexName) {
        this.newIndexName = newIndexName;
    }

    public void dryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.createIndexRequest.waitForActiveShards(waitForActiveShards);
    }

    public void addMaxIndexAgeCondition(TimeValue age) {
        MaxAgeCondition maxAgeCondition = new MaxAgeCondition(age);
        if (this.conditions.containsKey(maxAgeCondition.name)) {
            throw new IllegalArgumentException(maxAgeCondition.name + " condition is already set");
        }
        this.conditions.put(maxAgeCondition.name, maxAgeCondition);
    }

    public void addMaxIndexDocsCondition(long numDocs) {
        MaxDocsCondition maxDocsCondition = new MaxDocsCondition(numDocs);
        if (this.conditions.containsKey(maxDocsCondition.name)) {
            throw new IllegalArgumentException(maxDocsCondition.name + " condition is already set");
        }
        this.conditions.put(maxDocsCondition.name, maxDocsCondition);
    }

    public void addMaxIndexSizeCondition(ByteSizeValue size) {
        MaxSizeCondition maxSizeCondition = new MaxSizeCondition(size);
        if (this.conditions.containsKey(maxSizeCondition.name)) {
            throw new IllegalArgumentException(maxSizeCondition + " condition is already set");
        }
        this.conditions.put(maxSizeCondition.name, maxSizeCondition);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public Map<String, Condition<?>> getConditions() {
        return this.conditions;
    }

    public String getRolloverTarget() {
        return this.rolloverTarget;
    }

    public String getNewIndexName() {
        return this.newIndexName;
    }

    public CreateIndexRequest getCreateIndexRequest() {
        return this.createIndexRequest;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.createIndexRequest.innerToXContent(builder, params);
        builder.startObject(CONDITIONS.getPreferredName());
        for (Condition<?> condition : this.conditions.values()) {
            condition.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public void fromXContent(boolean isTypeIncluded, XContentParser parser) throws IOException {
        PARSER.parse(parser, this, isTypeIncluded);
    }

    static {
        CONDITION_PARSER.declareString((conditions, s) -> conditions.put("max_age", new MaxAgeCondition(TimeValue.parseTimeValue(s, "max_age"))), MAX_AGE_CONDITION);
        CONDITION_PARSER.declareLong((conditions, value) -> conditions.put("max_docs", new MaxDocsCondition((Long)value)), MAX_DOCS_CONDITION);
        CONDITION_PARSER.declareString((conditions, s) -> conditions.put("max_size", new MaxSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "max_size"))), MAX_SIZE_CONDITION);
        PARSER.declareField((parser, request, context) -> CONDITION_PARSER.parse(parser, request.conditions, null), CONDITIONS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.createIndexRequest.settings(parser.map()), CreateIndexRequest.SETTINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, includeTypeName) -> {
            if (includeTypeName.booleanValue()) {
                for (Map.Entry<String, Object> mappingsEntry : parser.map().entrySet()) {
                    request.createIndexRequest.mapping(mappingsEntry.getKey(), (Map)mappingsEntry.getValue());
                }
            } else {
                Map<String, Object> mappings = parser.map();
                if (MapperService.isMappingSourceTyped("_doc", mappings)) {
                    throw new IllegalArgumentException("The mapping definition cannot be nested under a type [_doc] unless include_type_name is set to true.");
                }
                request.createIndexRequest.mapping("_doc", mappings);
            }
        }, CreateIndexRequest.MAPPINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.createIndexRequest.aliases(parser.map()), CreateIndexRequest.ALIASES, ObjectParser.ValueType.OBJECT);
    }
}

