/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.broadcast.BroadcastRequest;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.tasks.CancellableTask;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;

public class FieldUsageTrackerRequest
extends BroadcastRequest<FieldUsageTrackerRequest> {
    private String[] fields = Strings.EMPTY_ARRAY;

    public FieldUsageTrackerRequest(String ... indices) {
        super(indices);
    }

    public FieldUsageTrackerRequest(String[] indices, IndicesOptions indicesOptions) {
        super(indices, indicesOptions);
    }

    public FieldUsageTrackerRequest(StreamInput in) throws IOException {
        super(in);
        this.fields = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.fields);
    }

    public FieldUsageTrackerRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, "indices:monitor/field_usage_stats", type, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return FieldUsageTrackerRequest.this.getDescription();
            }
        };
    }

    @Override
    public String getDescription() {
        return "get field usage for indices [" + String.join((CharSequence)",", this.indices) + "], fields " + Arrays.toString(this.fields);
    }
}

