/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.store.AlreadyClosedException;
import org.easysearch.action.admin.indices.stats.CommonStats;
import org.easysearch.action.admin.indices.stats.IndicesStatsRequest;
import org.easysearch.action.admin.indices.stats.IndicesStatsResponse;
import org.easysearch.action.admin.indices.stats.ShardStats;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.DefaultShardOperationFailedException;
import org.easysearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.routing.ShardsIterator;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.IndexService;
import org.easysearch.index.engine.CommitStats;
import org.easysearch.index.seqno.RetentionLeaseStats;
import org.easysearch.index.seqno.SeqNoStats;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.ShardNotFoundException;
import org.easysearch.indices.IndicesService;
import org.easysearch.transport.TransportService;

public class TransportIndicesStatsAction
extends TransportBroadcastByNodeAction<IndicesStatsRequest, IndicesStatsResponse, ShardStats> {
    private final IndicesService indicesService;

    @Inject
    public TransportIndicesStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, IndicesStatsRequest::new, "management");
        this.indicesService = indicesService;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, IndicesStatsRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, IndicesStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, IndicesStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    @Override
    protected ShardStats readShardResult(StreamInput in) throws IOException {
        return new ShardStats(in);
    }

    @Override
    protected IndicesStatsResponse newResponse(IndicesStatsRequest request, int totalShards, int successfulShards, int failedShards, List<ShardStats> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new IndicesStatsResponse(responses.toArray(new ShardStats[responses.size()]), totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected IndicesStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new IndicesStatsRequest(in);
    }

    @Override
    protected ShardStats shardOperation(IndicesStatsRequest request, ShardRouting shardRouting) {
        RetentionLeaseStats retentionLeaseStats;
        SeqNoStats seqNoStats;
        CommitStats commitStats;
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        if (indexShard.routingEntry() == null) {
            throw new ShardNotFoundException(indexShard.shardId());
        }
        CommonStats commonStats = new CommonStats(this.indicesService.getIndicesQueryCache(), indexShard, request.flags());
        try {
            commitStats = indexShard.commitStats();
            seqNoStats = indexShard.seqNoStats();
            retentionLeaseStats = indexShard.getRetentionLeaseStats();
        }
        catch (AlreadyClosedException e) {
            commitStats = null;
            seqNoStats = null;
            retentionLeaseStats = null;
        }
        return new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), commonStats, commitStats, seqNoStats, retentionLeaseStats);
    }
}

