/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.easysearch.action.admin.indices.template.post.SimulateTemplateAction;
import org.easysearch.action.admin.indices.template.post.TransportSimulateIndexTemplateAction;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.TransportMasterNodeReadAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.AliasValidator;
import org.easysearch.cluster.metadata.ComposableIndexTemplate;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.metadata.MetadataIndexTemplateService;
import org.easysearch.cluster.metadata.Template;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.UUIDs;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.indices.IndicesService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportSimulateTemplateAction
extends TransportMasterNodeReadAction<SimulateTemplateAction.Request, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private AliasValidator aliasValidator;

    @Inject
    public TransportSimulateTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndicesService indicesService) {
        super("indices:admin/index_template/simulate", transportService, clusterService, threadPool, actionFilters, SimulateTemplateAction.Request::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.aliasValidator = new AliasValidator();
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected SimulateIndexTemplateResponse read(StreamInput in) throws IOException {
        return new SimulateIndexTemplateResponse(in);
    }

    @Override
    protected void masterOperation(SimulateTemplateAction.Request request, ClusterState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ClusterState stateWithTemplate;
        Object simulateTemplateToAdd;
        String uuid = UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
        String temporaryIndexName = "simulate_template_index_" + uuid;
        if (request.getIndexTemplateRequest() != null) {
            simulateTemplateToAdd = request.getTemplateName() == null ? "simulate_template_" + uuid : request.getTemplateName();
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), (String)simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            stateWithTemplate = this.indexTemplateService.addIndexTemplateV2(state, request.getIndexTemplateRequest().create(), (String)simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
        } else {
            simulateTemplateToAdd = null;
            stateWithTemplate = state;
        }
        Object matchingTemplate = request.getTemplateName() == null ? simulateTemplateToAdd : request.getTemplateName();
        if (matchingTemplate == null) {
            listener.onFailure(new IllegalArgumentException("a template name to match or a new template body must be specified"));
            return;
        }
        if (!stateWithTemplate.metadata().templatesV2().containsKey(matchingTemplate)) {
            listener.onFailure(new IllegalArgumentException("unable to simulate template [" + (String)matchingTemplate + "] that does not exist"));
            return;
        }
        ClusterState tempClusterState = TransportSimulateIndexTemplateAction.resolveTemporaryState((String)matchingTemplate, temporaryIndexName, stateWithTemplate);
        ComposableIndexTemplate templateV2 = tempClusterState.metadata().templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempClusterState, (String)matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempClusterState, (String)matchingTemplate, templateV2.indexPatterns()));
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate((String)matchingTemplate, temporaryIndexName, stateWithTemplate, this.xContentRegistry, this.indicesService, this.aliasValidator);
        listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping));
    }

    @Override
    protected ClusterBlockException checkBlock(SimulateTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

