/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.delete;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.CompositeIndicesRequest;
import org.easysearch.action.DocWriteRequest;
import org.easysearch.action.ValidateActions;
import org.easysearch.action.support.replication.ReplicatedWriteRequest;
import org.easysearch.common.Nullable;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.VersionType;
import org.easysearch.index.shard.ShardId;

public class DeleteRequest
extends ReplicatedWriteRequest<DeleteRequest>
implements DocWriteRequest<DeleteRequest>,
CompositeIndicesRequest {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(DeleteRequest.class);
    private static final ShardId NO_SHARD_ID = null;
    private String type;
    private String id;
    @Nullable
    private String routing;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;

    public DeleteRequest(StreamInput in) throws IOException {
        this(null, in);
    }

    public DeleteRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        this.ifSeqNo = in.readZLong();
        this.ifPrimaryTerm = in.readVLong();
    }

    public DeleteRequest() {
        super(NO_SHARD_ID);
    }

    public DeleteRequest(String index) {
        super(NO_SHARD_ID);
        this.index = index;
    }

    @Deprecated
    public DeleteRequest(String index, String type, String id) {
        super(NO_SHARD_ID);
        this.index = index;
        this.type = type;
        this.id = id;
    }

    public DeleteRequest(String index, String id) {
        super(NO_SHARD_ID);
        this.index = index;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (Strings.isEmpty(this.type())) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams(this, validationException);
        return validationException;
    }

    @Override
    @Deprecated
    public String type() {
        if (this.type == null) {
            return "_doc";
        }
        return this.type;
    }

    @Override
    @Deprecated
    public DeleteRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Deprecated
    public DeleteRequest defaultTypeIfNull(String defaultType) {
        if (Strings.isNullOrEmpty(this.type)) {
            this.type = defaultType;
        }
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public DeleteRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public DeleteRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    @Override
    public DeleteRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public DeleteRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Override
    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Override
    public DeleteRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    @Override
    public DeleteRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return DocWriteRequest.OpType.DELETE;
    }

    @Override
    public boolean isRequireAlias() {
        return false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeBody(out);
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeThin(out);
        this.writeBody(out);
    }

    private void writeBody(StreamOutput out) throws IOException {
        out.writeString(this.type());
        out.writeString(this.id);
        out.writeOptionalString(this.routing());
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        out.writeZLong(this.ifSeqNo);
        out.writeVLong(this.ifPrimaryTerm);
    }

    @Override
    public String toString() {
        return "delete {[" + this.index + "][" + this.type() + "][" + this.id + "]}";
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.id);
    }
}

