/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.ingest;

import java.util.concurrent.atomic.AtomicInteger;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionListenerResponseHandler;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionType;
import org.easysearch.cluster.ClusterChangedEvent;
import org.easysearch.cluster.ClusterStateApplier;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.Randomness;
import org.easysearch.transport.TransportService;

public final class IngestActionForwarder
implements ClusterStateApplier {
    private final TransportService transportService;
    private final AtomicInteger ingestNodeGenerator = new AtomicInteger(Randomness.get().nextInt());
    private DiscoveryNode[] ingestNodes;

    public IngestActionForwarder(TransportService transportService) {
        this.transportService = transportService;
        this.ingestNodes = new DiscoveryNode[0];
    }

    public void forwardIngestRequest(ActionType<?> action, ActionRequest request, ActionListener<?> listener) {
        this.transportService.sendRequest(this.randomIngestNode(), action.name(), request, new ActionListenerResponseHandler(listener, action.getResponseReader()));
    }

    private DiscoveryNode randomIngestNode() {
        DiscoveryNode[] nodes = this.ingestNodes;
        if (nodes.length == 0) {
            throw new IllegalStateException("There are no ingest nodes in this cluster, unable to forward request to an ingest node.");
        }
        return nodes[Math.floorMod(this.ingestNodeGenerator.incrementAndGet(), nodes.length)];
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.ingestNodes = (DiscoveryNode[])event.state().getNodes().getIngestNodes().values().toArray(DiscoveryNode.class);
    }
}

