/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import org.easysearch.action.search.ArraySearchPhaseResults;
import org.easysearch.action.search.SearchPhaseContext;
import org.easysearch.common.Nullable;
import org.easysearch.common.util.concurrent.CountDown;
import org.easysearch.search.SearchPhaseResult;
import org.easysearch.search.SearchShardTarget;

final class CountedCollector<R extends SearchPhaseResult> {
    private final ArraySearchPhaseResults<R> resultConsumer;
    private final CountDown counter;
    private final Runnable onFinish;
    private final SearchPhaseContext context;

    CountedCollector(ArraySearchPhaseResults<R> resultConsumer, int expectedOps, Runnable onFinish, SearchPhaseContext context) {
        this.resultConsumer = resultConsumer;
        this.counter = new CountDown(expectedOps);
        this.onFinish = onFinish;
        this.context = context;
    }

    void countDown() {
        assert (!this.counter.isCountedDown()) : "more operations executed than specified";
        if (this.counter.countDown()) {
            this.onFinish.run();
        }
    }

    void onResult(R result) {
        this.resultConsumer.consumeResult(result, this::countDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
        try {
            this.context.onShardFailure(shardIndex, shardTarget, e);
        }
        finally {
            this.countDown();
        }
    }
}

