/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.support;

import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionRunnable;
import org.easysearch.client.Client;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.util.concurrent.AbstractRunnable;
import org.easysearch.threadpool.ThreadPool;

public final class ThreadedActionListener<Response>
implements ActionListener<Response> {
    private final Logger logger;
    private final ThreadPool threadPool;
    private final String executor;
    private final ActionListener<Response> listener;
    private final boolean forceExecution;

    public ThreadedActionListener(Logger logger, ThreadPool threadPool, String executor, ActionListener<Response> listener, boolean forceExecution) {
        this.logger = logger;
        this.threadPool = threadPool;
        this.executor = executor;
        this.listener = listener;
        this.forceExecution = forceExecution;
    }

    @Override
    public void onResponse(final Response response) {
        this.threadPool.executor(this.executor).execute(new ActionRunnable<Response>(this.listener){

            @Override
            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() {
                this.listener.onResponse(response);
            }
        });
    }

    @Override
    public void onFailure(final Exception e) {
        this.threadPool.executor(this.executor).execute(new AbstractRunnable(){

            @Override
            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() throws Exception {
                ThreadedActionListener.this.listener.onFailure(e);
            }

            @Override
            public void onFailure(Exception e2) {
                ThreadedActionListener.this.logger.warn(() -> new ParameterizedMessage("failed to execute failure callback on [{}]", ThreadedActionListener.this.listener), (Throwable)e2);
            }
        });
    }

    public static class Wrapper {
        private final Logger logger;
        private final ThreadPool threadPool;
        private final boolean threadedListener;

        public Wrapper(Logger logger, Settings settings, ThreadPool threadPool) {
            this.logger = logger;
            this.threadPool = threadPool;
            this.threadedListener = "transport".equals(Client.CLIENT_TYPE_SETTING_S.get(settings));
        }

        public <Response> ActionListener<Response> wrap(ActionListener<Response> listener) {
            if (!this.threadedListener) {
                return listener;
            }
            if (listener instanceof Future) {
                return listener;
            }
            if (listener instanceof ThreadedActionListener) {
                return listener;
            }
            return new ThreadedActionListener<Response>(this.logger, this.threadPool, "listener", listener, false);
        }
    }
}

