/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.easysearch.action.search.ShardSearchFailure;
import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParserUtils;
import org.easysearch.rest.RestStatus;

public final class CountResponse {
    static final ParseField COUNT = new ParseField("count", new String[0]);
    static final ParseField TERMINATED_EARLY = new ParseField("terminated_early", new String[0]);
    static final ParseField SHARDS = new ParseField("_shards", new String[0]);
    private final long count;
    private final Boolean terminatedEarly;
    private final ShardStats shardStats;

    public CountResponse(long count, Boolean terminatedEarly, ShardStats shardStats) {
        this.count = count;
        this.terminatedEarly = terminatedEarly;
        this.shardStats = shardStats;
    }

    public ShardStats getShardStats() {
        return this.shardStats;
    }

    public long getCount() {
        return this.count;
    }

    public int getTotalShards() {
        return this.shardStats.totalShards;
    }

    public int getSuccessfulShards() {
        return this.shardStats.successfulShards;
    }

    public int getSkippedShards() {
        return this.shardStats.skippedShards;
    }

    public int getFailedShards() {
        return this.shardStats.shardFailures.length;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardStats.shardFailures;
    }

    public RestStatus status() {
        return RestStatus.status(this.shardStats.successfulShards, this.shardStats.totalShards, this.shardStats.shardFailures);
    }

    public static CountResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String currentName = parser.currentName();
        Boolean terminatedEarly = null;
        long count = 0L;
        ShardStats shardStats = new ShardStats(-1, -1, 0, ShardSearchFailure.EMPTY_ARRAY);
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
            } else if (token.isValue()) {
                if (COUNT.match(currentName, parser.getDeprecationHandler())) {
                    count = parser.longValue();
                } else if (TERMINATED_EARLY.match(currentName, parser.getDeprecationHandler())) {
                    terminatedEarly = parser.booleanValue();
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if (SHARDS.match(currentName, parser.getDeprecationHandler())) {
                    shardStats = ShardStats.fromXContent(parser);
                } else {
                    parser.skipChildren();
                }
            }
            token = parser.nextToken();
        }
        return new CountResponse(count, terminatedEarly, shardStats);
    }

    public String toString() {
        String s = "{count=" + this.count + (String)(this.isTerminatedEarly() != null ? ", terminatedEarly=" + this.terminatedEarly : "") + ", " + this.shardStats + "}";
        return s;
    }

    public Boolean isTerminatedEarly() {
        return this.terminatedEarly;
    }

    public static final class ShardStats {
        static final ParseField FAILED = new ParseField("failed", new String[0]);
        static final ParseField SKIPPED = new ParseField("skipped", new String[0]);
        static final ParseField TOTAL = new ParseField("total", new String[0]);
        static final ParseField SUCCESSFUL = new ParseField("successful", new String[0]);
        static final ParseField FAILURES = new ParseField("failures", new String[0]);
        private final int successfulShards;
        private final int totalShards;
        private final int skippedShards;
        private final ShardSearchFailure[] shardFailures;

        public ShardStats(int successfulShards, int totalShards, int skippedShards, ShardSearchFailure[] shardFailures) {
            this.successfulShards = successfulShards;
            this.totalShards = totalShards;
            this.skippedShards = skippedShards;
            this.shardFailures = Arrays.copyOf(shardFailures, shardFailures.length);
        }

        public int getSuccessfulShards() {
            return this.successfulShards;
        }

        public int getTotalShards() {
            return this.totalShards;
        }

        public int getSkippedShards() {
            return this.skippedShards;
        }

        public ShardSearchFailure[] getShardFailures() {
            return (ShardSearchFailure[])Arrays.copyOf(this.shardFailures, this.shardFailures.length, ShardSearchFailure[].class);
        }

        static ShardStats fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token;
            int successfulShards = -1;
            int totalShards = -1;
            int skippedShards = 0;
            ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
            String currentName = parser.currentName();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (FAILED.match(currentName, parser.getDeprecationHandler())) {
                        parser.intValue();
                        continue;
                    }
                    if (SKIPPED.match(currentName, parser.getDeprecationHandler())) {
                        skippedShards = parser.intValue();
                        continue;
                    }
                    if (TOTAL.match(currentName, parser.getDeprecationHandler())) {
                        totalShards = parser.intValue();
                        continue;
                    }
                    if (SUCCESSFUL.match(currentName, parser.getDeprecationHandler())) {
                        successfulShards = parser.intValue();
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (FAILURES.match(currentName, parser.getDeprecationHandler())) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            failures.add(ShardSearchFailure.fromXContent(parser));
                        }
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                parser.skipChildren();
            }
            return new ShardStats(successfulShards, totalShards, skippedShards, failures.toArray(new ShardSearchFailure[failures.size()]));
        }

        public String toString() {
            return "_shards : {total=" + this.totalShards + ", successful=" + this.successfulShards + ", skipped=" + this.skippedShards + ", failed=" + (this.shardFailures != null && this.shardFailures.length > 0 ? this.shardFailures.length : 0) + (String)(this.shardFailures != null && this.shardFailures.length > 0 ? ", failures: " + Arrays.asList(this.shardFailures) : "") + "}";
        }
    }
}

