/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.routing.ShardRoutingState;
import org.easysearch.common.Nullable;
import org.easysearch.index.Index;
import org.easysearch.index.shard.ShardId;

public class RoutingNode
implements Iterable<ShardRouting> {
    private final String nodeId;
    private final DiscoveryNode node;
    private final LinkedHashMap<ShardId, ShardRouting> shards;
    private final LinkedHashSet<ShardRouting> initializingShards;
    private final LinkedHashSet<ShardRouting> relocatingShards;
    private final HashMap<Index, LinkedHashSet<ShardRouting>> shardsByIndex;

    public RoutingNode(String nodeId, DiscoveryNode node, ShardRouting ... shards) {
        this(nodeId, node, RoutingNode.buildShardRoutingMap(shards));
    }

    RoutingNode(String nodeId, DiscoveryNode node, LinkedHashMap<ShardId, ShardRouting> shards) {
        this.nodeId = nodeId;
        this.node = node;
        this.shards = shards;
        this.relocatingShards = new LinkedHashSet();
        this.initializingShards = new LinkedHashSet();
        this.shardsByIndex = new LinkedHashMap<Index, LinkedHashSet<ShardRouting>>();
        for (ShardRouting shardRouting : shards.values()) {
            if (shardRouting.initializing()) {
                this.initializingShards.add(shardRouting);
            } else if (shardRouting.relocating()) {
                this.relocatingShards.add(shardRouting);
            }
            this.shardsByIndex.computeIfAbsent(shardRouting.index(), k -> new LinkedHashSet()).add(shardRouting);
        }
        assert (this.invariant());
    }

    private static LinkedHashMap<ShardId, ShardRouting> buildShardRoutingMap(ShardRouting ... shardRoutings) {
        LinkedHashMap<ShardId, ShardRouting> shards = new LinkedHashMap<ShardId, ShardRouting>();
        for (ShardRouting shardRouting : shardRoutings) {
            ShardRouting previousValue = shards.put(shardRouting.shardId(), shardRouting);
            if (previousValue == null) continue;
            throw new IllegalArgumentException("Cannot have two different shards with same shard id " + shardRouting.shardId() + " on same node ");
        }
        return shards;
    }

    @Override
    public Iterator<ShardRouting> iterator() {
        return Collections.unmodifiableCollection(this.shards.values()).iterator();
    }

    public DiscoveryNode node() {
        return this.node;
    }

    @Nullable
    public ShardRouting getByShardId(ShardId id) {
        return this.shards.get(id);
    }

    public String nodeId() {
        return this.nodeId;
    }

    public int size() {
        return this.shards.size();
    }

    void add(ShardRouting shard) {
        assert (this.invariant());
        if (this.shards.containsKey(shard.shardId())) {
            throw new IllegalStateException("Trying to add a shard " + shard.shardId() + " to a node [" + this.nodeId + "] where it already exists. current [" + this.shards.get(shard.shardId()) + "]. new [" + shard + "]");
        }
        this.shards.put(shard.shardId(), shard);
        if (shard.initializing()) {
            this.initializingShards.add(shard);
        } else if (shard.relocating()) {
            this.relocatingShards.add(shard);
        }
        this.shardsByIndex.computeIfAbsent(shard.index(), k -> new LinkedHashSet()).add(shard);
        assert (this.invariant());
    }

    void update(ShardRouting oldShard, ShardRouting newShard) {
        assert (this.invariant());
        if (!this.shards.containsKey(oldShard.shardId())) {
            return;
        }
        ShardRouting previousValue = this.shards.put(newShard.shardId(), newShard);
        assert (previousValue == oldShard) : "expected shard " + previousValue + " but was " + oldShard;
        if (oldShard.initializing()) {
            boolean exist = this.initializingShards.remove(oldShard);
            assert (exist) : "expected shard " + oldShard + " to exist in initializingShards";
        } else if (oldShard.relocating()) {
            boolean exist = this.relocatingShards.remove(oldShard);
            assert (exist) : "expected shard " + oldShard + " to exist in relocatingShards";
        }
        this.shardsByIndex.get(oldShard.index()).remove(oldShard);
        if (this.shardsByIndex.get(oldShard.index()).isEmpty()) {
            this.shardsByIndex.remove(oldShard.index());
        }
        if (newShard.initializing()) {
            this.initializingShards.add(newShard);
        } else if (newShard.relocating()) {
            this.relocatingShards.add(newShard);
        }
        this.shardsByIndex.computeIfAbsent(newShard.index(), k -> new LinkedHashSet()).add(newShard);
        assert (this.invariant());
    }

    void remove(ShardRouting shard) {
        assert (this.invariant());
        ShardRouting previousValue = (ShardRouting)this.shards.remove(shard.shardId());
        assert (previousValue == shard) : "expected shard " + previousValue + " but was " + shard;
        if (shard.initializing()) {
            boolean exist = this.initializingShards.remove(shard);
            assert (exist) : "expected shard " + shard + " to exist in initializingShards";
        } else if (shard.relocating()) {
            boolean exist = this.relocatingShards.remove(shard);
            assert (exist) : "expected shard " + shard + " to exist in relocatingShards";
        }
        this.shardsByIndex.get(shard.index()).remove(shard);
        if (this.shardsByIndex.get(shard.index()).isEmpty()) {
            this.shardsByIndex.remove(shard.index());
        }
        assert (this.invariant());
    }

    public int numberOfShardsWithState(ShardRoutingState ... states) {
        if (states.length == 1) {
            if (states[0] == ShardRoutingState.INITIALIZING) {
                return this.initializingShards.size();
            }
            if (states[0] == ShardRoutingState.RELOCATING) {
                return this.relocatingShards.size();
            }
        }
        int count = 0;
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                ++count;
            }
        }
        return count;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        if (states.length == 1) {
            if (states[0] == ShardRoutingState.INITIALIZING) {
                return new ArrayList<ShardRouting>(this.initializingShards);
            }
            if (states[0] == ShardRoutingState.RELOCATING) {
                return new ArrayList<ShardRouting>(this.relocatingShards);
            }
        }
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(String index, ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        if (states.length == 1) {
            if (states[0] == ShardRoutingState.INITIALIZING) {
                for (ShardRouting shardEntry : this.initializingShards) {
                    if (!shardEntry.getIndexName().equals(index)) continue;
                    shards.add(shardEntry);
                }
                return shards;
            }
            if (states[0] == ShardRoutingState.RELOCATING) {
                for (ShardRouting shardEntry : this.relocatingShards) {
                    if (!shardEntry.getIndexName().equals(index)) continue;
                    shards.add(shardEntry);
                }
                return shards;
            }
        }
        for (ShardRouting shardEntry : this) {
            if (!shardEntry.getIndexName().equals(index)) continue;
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public int numberOfOwningShards() {
        return this.shards.size() - this.relocatingShards.size();
    }

    public int numberOfOwningShardsForIndex(Index index) {
        LinkedHashSet<ShardRouting> shardRoutings = this.shardsByIndex.get(index);
        if (shardRoutings == null) {
            return 0;
        }
        return Math.toIntExact(shardRoutings.stream().filter(sr -> !sr.relocating()).count());
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----node_id[").append(this.nodeId).append("][").append(this.node == null ? "X" : "V").append("]\n");
        for (ShardRouting entry : this.shards.values()) {
            sb.append("--------").append(entry.shortSummary()).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("routingNode ([");
        sb.append(this.node.getName());
        sb.append("][");
        sb.append(this.node.getId());
        sb.append("][");
        sb.append(this.node.getHostName());
        sb.append("][");
        sb.append(this.node.getHostAddress());
        sb.append("], [");
        sb.append(this.shards.size());
        sb.append(" assigned shards])");
        return sb.toString();
    }

    public List<ShardRouting> copyShards() {
        return new ArrayList<ShardRouting>(this.shards.values());
    }

    public boolean isEmpty() {
        return this.shards.isEmpty();
    }

    private boolean invariant() {
        Collection shardRoutingsInitializing = this.shards.values().stream().filter(ShardRouting::initializing).collect(Collectors.toList());
        assert (this.initializingShards.size() == shardRoutingsInitializing.size());
        assert (this.initializingShards.containsAll(shardRoutingsInitializing));
        Collection shardRoutingsRelocating = this.shards.values().stream().filter(ShardRouting::relocating).collect(Collectors.toList());
        assert (this.relocatingShards.size() == shardRoutingsRelocating.size());
        assert (this.relocatingShards.containsAll(shardRoutingsRelocating));
        Map shardRoutingsByIndex = this.shards.values().stream().collect(Collectors.groupingBy(ShardRouting::index, Collectors.toSet()));
        assert (shardRoutingsByIndex.equals(this.shardsByIndex));
        return true;
    }
}

