/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.component;

public class Lifecycle {
    private volatile State state = State.INITIALIZED;

    public State state() {
        return this.state;
    }

    public boolean initialized() {
        return this.state == State.INITIALIZED;
    }

    public boolean started() {
        return this.state == State.STARTED;
    }

    public boolean stopped() {
        return this.state == State.STOPPED;
    }

    public boolean closed() {
        return this.state == State.CLOSED;
    }

    public boolean stoppedOrClosed() {
        State state = this.state;
        return state == State.STOPPED || state == State.CLOSED;
    }

    public boolean canMoveToStarted() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            return true;
        }
        if (localState == State.STARTED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to started state when closed");
        }
        throw new IllegalStateException("Can't move to started with unknown state");
    }

    public synchronized boolean moveToStarted() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            this.state = State.STARTED;
            return true;
        }
        if (localState == State.STARTED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to started state when closed");
        }
        throw new IllegalStateException("Can't move to started with unknown state");
    }

    public boolean canMoveToStopped() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.STARTED) {
            return true;
        }
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to stopped state when closed");
        }
        throw new IllegalStateException("Can't move to stopped with unknown state");
    }

    public synchronized boolean moveToStopped() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.STARTED) {
            this.state = State.STOPPED;
            return true;
        }
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to stopped state when closed");
        }
        throw new IllegalStateException("Can't move to stopped with unknown state");
    }

    public boolean canMoveToClosed() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.CLOSED) {
            return false;
        }
        if (localState == State.STARTED) {
            throw new IllegalStateException("Can't move to closed before moving to stopped mode");
        }
        return true;
    }

    public synchronized boolean moveToClosed() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.CLOSED) {
            return false;
        }
        if (localState == State.STARTED) {
            throw new IllegalStateException("Can't move to closed before moving to stopped mode");
        }
        this.state = State.CLOSED;
        return true;
    }

    public String toString() {
        return this.state.toString();
    }

    public static enum State {
        INITIALIZED,
        STOPPED,
        STARTED,
        CLOSED;

    }
}

