/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject.internal;

import java.util.Collections;
import java.util.Set;
import org.easysearch.common.inject.Binder;
import org.easysearch.common.inject.Injector;
import org.easysearch.common.inject.Key;
import org.easysearch.common.inject.internal.BindingImpl;
import org.easysearch.common.inject.internal.InternalFactory;
import org.easysearch.common.inject.internal.Scoping;
import org.easysearch.common.inject.internal.ToStringBuilder;
import org.easysearch.common.inject.spi.BindingTargetVisitor;
import org.easysearch.common.inject.spi.Dependency;
import org.easysearch.common.inject.spi.ExposedBinding;
import org.easysearch.common.inject.spi.PrivateElements;

public class ExposedBindingImpl<T>
extends BindingImpl<T>
implements ExposedBinding<T> {
    private final PrivateElements privateElements;

    public ExposedBindingImpl(Injector injector, Object source, Key<T> key, InternalFactory<T> factory, PrivateElements privateElements) {
        super(injector, key, source, factory, Scoping.UNSCOPED);
        this.privateElements = privateElements;
    }

    public ExposedBindingImpl(Object source, Key<T> key, Scoping scoping, PrivateElements privateElements) {
        super(source, key, scoping);
        this.privateElements = privateElements;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return Collections.singleton(Dependency.get(Key.get(Injector.class)));
    }

    @Override
    public PrivateElements getPrivateElements() {
        return this.privateElements;
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new ExposedBindingImpl(this.getSource(), this.getKey(), scoping, this.privateElements);
    }

    @Override
    public ExposedBindingImpl<T> withKey(Key<T> key) {
        return new ExposedBindingImpl<T>(this.getSource(), key, this.getScoping(), this.privateElements);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(ExposedBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("privateElements", this.privateElements).toString();
    }

    @Override
    public void applyTo(Binder binder) {
        throw new UnsupportedOperationException("This element represents a synthetic binding.");
    }
}

