/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.easysearch.common.SuppressForbidden;
import org.easysearch.common.lucene.index.EasysearchLeafReader;
import org.easysearch.index.shard.ShardId;

public final class EasysearchDirectoryReader
extends FilterDirectoryReader {
    private final ShardId shardId;
    private final FilterDirectoryReader.SubReaderWrapper wrapper;

    private EasysearchDirectoryReader(DirectoryReader in, FilterDirectoryReader.SubReaderWrapper wrapper, ShardId shardId) throws IOException {
        super(in, wrapper);
        this.wrapper = wrapper;
        this.shardId = shardId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new EasysearchDirectoryReader(in, this.wrapper, this.shardId);
    }

    public static EasysearchDirectoryReader wrap(DirectoryReader reader, ShardId shardId) throws IOException {
        return new EasysearchDirectoryReader(reader, new SubReaderWrapper(shardId), shardId);
    }

    @SuppressForbidden(reason="This is the only sane way to add a ReaderClosedListener")
    public static void addReaderCloseListener(DirectoryReader reader, IndexReader.ClosedListener listener) {
        EasysearchDirectoryReader easysearchDirectoryReader = EasysearchDirectoryReader.getEasysearchDirectoryReader(reader);
        if (easysearchDirectoryReader == null) {
            throw new IllegalArgumentException("Can't install close listener reader is not an EasysearchDirectoryReader/EasysearchLeafReader");
        }
        IndexReader.CacheHelper cacheHelper = easysearchDirectoryReader.getReaderCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + easysearchDirectoryReader + " does not support caching");
        }
        assert (cacheHelper.getKey() == reader.getReaderCacheHelper().getKey());
        cacheHelper.addClosedListener(listener);
    }

    public static EasysearchDirectoryReader getEasysearchDirectoryReader(DirectoryReader reader) {
        if (reader instanceof FilterDirectoryReader) {
            if (reader instanceof EasysearchDirectoryReader) {
                return (EasysearchDirectoryReader)reader;
            }
            return EasysearchDirectoryReader.getEasysearchDirectoryReader(((FilterDirectoryReader)reader).getDelegate());
        }
        return null;
    }

    private static final class SubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final ShardId shardId;

        SubReaderWrapper(ShardId shardId) {
            this.shardId = shardId;
        }

        public LeafReader wrap(LeafReader reader) {
            return new EasysearchLeafReader(reader, this.shardId);
        }
    }
}

