/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.engine;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.util.function.Supplier;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.easysearch.action.ActionListener;
import org.easysearch.action.support.PlainActionFuture;
import org.easysearch.common.FieldMemoryStats;
import org.easysearch.common.Nullable;
import org.easysearch.common.regex.Regex;
import org.easysearch.common.util.CollectionUtils;
import org.easysearch.index.engine.Engine;
import org.easysearch.search.suggest.completion.CompletionStats;

class CompletionStatsCache
implements ReferenceManager.RefreshListener {
    private final Supplier<Engine.Searcher> searcherSupplier;
    @Nullable
    private PlainActionFuture<CompletionStats> completionStatsFuture;
    private final Object completionStatsFutureMutex = new Object();

    CompletionStatsCache(Supplier<Engine.Searcher> searcherSupplier) {
        this.searcherSupplier = searcherSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletionStats get(String ... fieldNamePatterns) {
        CompletionStats completionStats;
        PlainActionFuture<CompletionStats> oldFuture;
        PlainActionFuture newFuture = new PlainActionFuture();
        Object object = this.completionStatsFutureMutex;
        synchronized (object) {
            if (this.completionStatsFuture == null) {
                this.completionStatsFuture = newFuture;
                oldFuture = null;
            } else {
                oldFuture = this.completionStatsFuture;
            }
        }
        if (oldFuture != null) {
            return CompletionStatsCache.filterCompletionStatsByFieldName(fieldNamePatterns, (CompletionStats)oldFuture.actionGet());
        }
        ActionListener.completeWith(newFuture, () -> {
            long sizeInBytes = 0L;
            ObjectLongHashMap completionFields = new ObjectLongHashMap();
            try (Engine.Searcher currentSearcher = this.searcherSupplier.get();){
                for (LeafReaderContext atomicReaderContext : currentSearcher.getIndexReader().leaves()) {
                    LeafReader atomicReader = atomicReaderContext.reader();
                    for (FieldInfo info : atomicReader.getFieldInfos()) {
                        Terms terms = atomicReader.terms(info.name);
                        if (!(terms instanceof CompletionTerms)) continue;
                        long fstSize = ((CompletionTerms)terms).suggester().ramBytesUsed();
                        completionFields.addTo((Object)info.name, fstSize);
                        sizeInBytes += fstSize;
                    }
                }
            }
            return new CompletionStats(sizeInBytes, new FieldMemoryStats((ObjectLongHashMap<String>)completionFields));
        });
        boolean success = false;
        try {
            completionStats = (CompletionStats)newFuture.actionGet();
            success = true;
        }
        finally {
            if (!success) {
                Object object2 = this.completionStatsFutureMutex;
                synchronized (object2) {
                    if (this.completionStatsFuture == newFuture) {
                        this.completionStatsFuture = null;
                    }
                }
            }
        }
        return CompletionStatsCache.filterCompletionStatsByFieldName(fieldNamePatterns, completionStats);
    }

    private static CompletionStats filterCompletionStatsByFieldName(String[] fieldNamePatterns, CompletionStats fullCompletionStats) {
        FieldMemoryStats fieldMemoryStats;
        if (!CollectionUtils.isEmpty(fieldNamePatterns)) {
            ObjectLongHashMap completionFields = new ObjectLongHashMap(fieldNamePatterns.length);
            for (ObjectLongCursor<String> fieldCursor : fullCompletionStats.getFields()) {
                if (!Regex.simpleMatch(fieldNamePatterns, (String)fieldCursor.key)) continue;
                completionFields.addTo((Object)((String)fieldCursor.key), fieldCursor.value);
            }
            fieldMemoryStats = new FieldMemoryStats((ObjectLongHashMap<String>)completionFields);
        } else {
            fieldMemoryStats = null;
        }
        return new CompletionStats(fullCompletionStats.getSizeInBytes(), fieldMemoryStats);
    }

    public void beforeRefresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRefresh(boolean didRefresh) {
        if (didRefresh) {
            Object object = this.completionStatsFutureMutex;
            synchronized (object) {
                this.completionStatsFuture = null;
            }
        }
    }
}

