/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.engine;

import java.io.IOException;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.engine.Engine;
import org.easysearch.index.engine.EngineException;
import org.easysearch.index.shard.ShardId;
import org.easysearch.rest.RestStatus;

public class VersionConflictEngineException
extends EngineException {
    public VersionConflictEngineException(ShardId shardId, Engine.Operation op, long currentVersion, boolean deleted) {
        this(shardId, op.id(), op.versionType().explainConflictForWrites(currentVersion, op.version(), deleted));
    }

    public VersionConflictEngineException(ShardId shardId, String id, long compareAndWriteSeqNo, long compareAndWriteTerm, long currentSeqNo, long currentTerm) {
        this(shardId, id, "required seqNo [" + compareAndWriteSeqNo + "], primary term [" + compareAndWriteTerm + "]." + (String)(currentSeqNo == -2L ? " but no document was found" : " current document has seqNo [" + currentSeqNo + "] and primary term [" + currentTerm + "]"));
    }

    public VersionConflictEngineException(ShardId shardId, String id, String explanation) {
        this(shardId, "[{}]: version conflict, {}", null, id, explanation);
    }

    public VersionConflictEngineException(ShardId shardId, String msg, Throwable cause, Object ... params) {
        super(shardId, msg, cause, params);
    }

    @Override
    public RestStatus status() {
        return RestStatus.CONFLICT;
    }

    public VersionConflictEngineException(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }
}

