/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.query;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.join.ScoreMode;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.geo.GeoPoint;
import org.easysearch.common.geo.ShapeRelation;
import org.easysearch.common.geo.builders.ShapeBuilder;
import org.easysearch.geometry.Geometry;
import org.easysearch.index.query.BoolQueryBuilder;
import org.easysearch.index.query.BoostingQueryBuilder;
import org.easysearch.index.query.CommonTermsQueryBuilder;
import org.easysearch.index.query.ConstantScoreQueryBuilder;
import org.easysearch.index.query.DisMaxQueryBuilder;
import org.easysearch.index.query.DistanceFeatureQueryBuilder;
import org.easysearch.index.query.ExistsQueryBuilder;
import org.easysearch.index.query.FieldMaskingSpanQueryBuilder;
import org.easysearch.index.query.FuzzyQueryBuilder;
import org.easysearch.index.query.GeoBoundingBoxQueryBuilder;
import org.easysearch.index.query.GeoDistanceQueryBuilder;
import org.easysearch.index.query.GeoPolygonQueryBuilder;
import org.easysearch.index.query.GeoShapeQueryBuilder;
import org.easysearch.index.query.IdsQueryBuilder;
import org.easysearch.index.query.MatchAllQueryBuilder;
import org.easysearch.index.query.MatchBoolPrefixQueryBuilder;
import org.easysearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.easysearch.index.query.MatchPhraseQueryBuilder;
import org.easysearch.index.query.MatchQueryBuilder;
import org.easysearch.index.query.MoreLikeThisQueryBuilder;
import org.easysearch.index.query.MultiMatchQueryBuilder;
import org.easysearch.index.query.MultiTermQueryBuilder;
import org.easysearch.index.query.NestedQueryBuilder;
import org.easysearch.index.query.PrefixQueryBuilder;
import org.easysearch.index.query.QueryBuilder;
import org.easysearch.index.query.QueryStringQueryBuilder;
import org.easysearch.index.query.RangeQueryBuilder;
import org.easysearch.index.query.RegexpQueryBuilder;
import org.easysearch.index.query.ScriptQueryBuilder;
import org.easysearch.index.query.SimpleQueryStringBuilder;
import org.easysearch.index.query.SpanContainingQueryBuilder;
import org.easysearch.index.query.SpanFirstQueryBuilder;
import org.easysearch.index.query.SpanMultiTermQueryBuilder;
import org.easysearch.index.query.SpanNearQueryBuilder;
import org.easysearch.index.query.SpanNotQueryBuilder;
import org.easysearch.index.query.SpanOrQueryBuilder;
import org.easysearch.index.query.SpanQueryBuilder;
import org.easysearch.index.query.SpanTermQueryBuilder;
import org.easysearch.index.query.SpanWithinQueryBuilder;
import org.easysearch.index.query.TermQueryBuilder;
import org.easysearch.index.query.TermsQueryBuilder;
import org.easysearch.index.query.TypeQueryBuilder;
import org.easysearch.index.query.WildcardQueryBuilder;
import org.easysearch.index.query.WrapperQueryBuilder;
import org.easysearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.easysearch.index.query.functionscore.ScoreFunctionBuilder;
import org.easysearch.index.query.functionscore.ScriptScoreQueryBuilder;
import org.easysearch.indices.TermsLookup;
import org.easysearch.script.Script;

public final class QueryBuilders {
    private QueryBuilders() {
    }

    public static MatchAllQueryBuilder matchAllQuery() {
        return new MatchAllQueryBuilder();
    }

    public static MatchQueryBuilder matchQuery(String name, Object text) {
        return new MatchQueryBuilder(name, text);
    }

    @Deprecated
    public static CommonTermsQueryBuilder commonTermsQuery(String fieldName, Object text) {
        return new CommonTermsQueryBuilder(fieldName, text);
    }

    public static MultiMatchQueryBuilder multiMatchQuery(Object text, String ... fieldNames) {
        return new MultiMatchQueryBuilder(text, fieldNames);
    }

    public static MatchBoolPrefixQueryBuilder matchBoolPrefixQuery(String name, Object text) {
        return new MatchBoolPrefixQueryBuilder(name, text);
    }

    public static MatchPhraseQueryBuilder matchPhraseQuery(String name, Object text) {
        return new MatchPhraseQueryBuilder(name, text);
    }

    public static MatchPhrasePrefixQueryBuilder matchPhrasePrefixQuery(String name, Object text) {
        return new MatchPhrasePrefixQueryBuilder(name, text);
    }

    public static DisMaxQueryBuilder disMaxQuery() {
        return new DisMaxQueryBuilder();
    }

    public static DistanceFeatureQueryBuilder distanceFeatureQuery(String name, DistanceFeatureQueryBuilder.Origin origin, String pivot) {
        return new DistanceFeatureQueryBuilder(name, origin, pivot);
    }

    public static IdsQueryBuilder idsQuery() {
        return new IdsQueryBuilder();
    }

    @Deprecated
    public static IdsQueryBuilder idsQuery(String ... types) {
        return new IdsQueryBuilder().types(types);
    }

    public static TermQueryBuilder termQuery(String name, String value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, int value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, long value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, float value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, double value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, boolean value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, Object value) {
        return new TermQueryBuilder(name, value);
    }

    public static FuzzyQueryBuilder fuzzyQuery(String name, String value) {
        return new FuzzyQueryBuilder(name, value);
    }

    public static FuzzyQueryBuilder fuzzyQuery(String name, Object value) {
        return new FuzzyQueryBuilder(name, value);
    }

    public static PrefixQueryBuilder prefixQuery(String name, String prefix) {
        return new PrefixQueryBuilder(name, prefix);
    }

    public static RangeQueryBuilder rangeQuery(String name) {
        return new RangeQueryBuilder(name);
    }

    public static WildcardQueryBuilder wildcardQuery(String name, String query) {
        return new WildcardQueryBuilder(name, query);
    }

    public static RegexpQueryBuilder regexpQuery(String name, String regexp) {
        return new RegexpQueryBuilder(name, regexp);
    }

    public static QueryStringQueryBuilder queryStringQuery(String queryString) {
        return new QueryStringQueryBuilder(queryString);
    }

    public static SimpleQueryStringBuilder simpleQueryStringQuery(String queryString) {
        return new SimpleQueryStringBuilder(queryString);
    }

    public static BoostingQueryBuilder boostingQuery(QueryBuilder positiveQuery, QueryBuilder negativeQuery) {
        return new BoostingQueryBuilder(positiveQuery, negativeQuery);
    }

    public static BoolQueryBuilder boolQuery() {
        return new BoolQueryBuilder();
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, String value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, int value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, long value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, float value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, double value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanFirstQueryBuilder spanFirstQuery(SpanQueryBuilder match, int end) {
        return new SpanFirstQueryBuilder(match, end);
    }

    public static SpanNearQueryBuilder spanNearQuery(SpanQueryBuilder initialClause, int slop) {
        return new SpanNearQueryBuilder(initialClause, slop);
    }

    public static SpanNotQueryBuilder spanNotQuery(SpanQueryBuilder include, SpanQueryBuilder exclude) {
        return new SpanNotQueryBuilder(include, exclude);
    }

    public static SpanOrQueryBuilder spanOrQuery(SpanQueryBuilder initialClause) {
        return new SpanOrQueryBuilder(initialClause);
    }

    public static SpanWithinQueryBuilder spanWithinQuery(SpanQueryBuilder big, SpanQueryBuilder little) {
        return new SpanWithinQueryBuilder(big, little);
    }

    public static SpanContainingQueryBuilder spanContainingQuery(SpanQueryBuilder big, SpanQueryBuilder little) {
        return new SpanContainingQueryBuilder(big, little);
    }

    public static SpanMultiTermQueryBuilder spanMultiTermQueryBuilder(MultiTermQueryBuilder multiTermQueryBuilder) {
        return new SpanMultiTermQueryBuilder(multiTermQueryBuilder);
    }

    public static FieldMaskingSpanQueryBuilder fieldMaskingSpanQuery(SpanQueryBuilder query, String field) {
        return new FieldMaskingSpanQueryBuilder(query, field);
    }

    public static ConstantScoreQueryBuilder constantScoreQuery(QueryBuilder queryBuilder) {
        return new ConstantScoreQueryBuilder(queryBuilder);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(QueryBuilder queryBuilder) {
        return new FunctionScoreQueryBuilder(queryBuilder);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(QueryBuilder queryBuilder, FunctionScoreQueryBuilder.FilterFunctionBuilder[] filterFunctionBuilders) {
        return new FunctionScoreQueryBuilder(queryBuilder, filterFunctionBuilders);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(FunctionScoreQueryBuilder.FilterFunctionBuilder[] filterFunctionBuilders) {
        return new FunctionScoreQueryBuilder(filterFunctionBuilders);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(ScoreFunctionBuilder function) {
        return new FunctionScoreQueryBuilder(function);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(QueryBuilder queryBuilder, ScoreFunctionBuilder function) {
        return new FunctionScoreQueryBuilder(queryBuilder, function);
    }

    public static ScriptScoreQueryBuilder scriptScoreQuery(QueryBuilder queryBuilder, Script script) {
        return new ScriptScoreQueryBuilder(queryBuilder, script);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(String[] fields, String[] likeTexts, MoreLikeThisQueryBuilder.Item[] likeItems) {
        return new MoreLikeThisQueryBuilder(fields, likeTexts, likeItems);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(String[] likeTexts, MoreLikeThisQueryBuilder.Item[] likeItems) {
        return QueryBuilders.moreLikeThisQuery(null, likeTexts, likeItems);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(String[] likeTexts) {
        return QueryBuilders.moreLikeThisQuery(null, likeTexts, null);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(MoreLikeThisQueryBuilder.Item[] likeItems) {
        return QueryBuilders.moreLikeThisQuery(null, null, likeItems);
    }

    public static NestedQueryBuilder nestedQuery(String path, QueryBuilder query, ScoreMode scoreMode) {
        return new NestedQueryBuilder(path, query, scoreMode);
    }

    public static TermsQueryBuilder termsQuery(String name, String ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, int ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, long ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, float ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, double ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, Object ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, Collection<?> values) {
        return new TermsQueryBuilder(name, values);
    }

    public static WrapperQueryBuilder wrapperQuery(String source) {
        return new WrapperQueryBuilder(source);
    }

    public static WrapperQueryBuilder wrapperQuery(BytesReference source) {
        return new WrapperQueryBuilder(source);
    }

    public static WrapperQueryBuilder wrapperQuery(byte[] source) {
        return new WrapperQueryBuilder(source);
    }

    @Deprecated
    public static TypeQueryBuilder typeQuery(String type) {
        return new TypeQueryBuilder(type);
    }

    public static TermsQueryBuilder termsLookupQuery(String name, TermsLookup termsLookup) {
        return new TermsQueryBuilder(name, termsLookup);
    }

    public static ScriptQueryBuilder scriptQuery(Script script) {
        return new ScriptQueryBuilder(script);
    }

    public static GeoDistanceQueryBuilder geoDistanceQuery(String name) {
        return new GeoDistanceQueryBuilder(name);
    }

    public static GeoBoundingBoxQueryBuilder geoBoundingBoxQuery(String name) {
        return new GeoBoundingBoxQueryBuilder(name);
    }

    public static GeoPolygonQueryBuilder geoPolygonQuery(String name, List<GeoPoint> points) {
        return new GeoPolygonQueryBuilder(name, points);
    }

    public static GeoShapeQueryBuilder geoShapeQuery(String name, Geometry shape) throws IOException {
        return new GeoShapeQueryBuilder(name, shape);
    }

    @Deprecated
    public static GeoShapeQueryBuilder geoShapeQuery(String name, ShapeBuilder shape) throws IOException {
        return new GeoShapeQueryBuilder(name, shape);
    }

    public static GeoShapeQueryBuilder geoShapeQuery(String name, String indexedShapeId) {
        return new GeoShapeQueryBuilder(name, indexedShapeId);
    }

    @Deprecated
    public static GeoShapeQueryBuilder geoShapeQuery(String name, String indexedShapeId, String indexedShapeType) {
        return new GeoShapeQueryBuilder(name, indexedShapeId, indexedShapeType);
    }

    public static GeoShapeQueryBuilder geoIntersectionQuery(String name, Geometry shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.INTERSECTS);
        return builder;
    }

    @Deprecated
    public static GeoShapeQueryBuilder geoIntersectionQuery(String name, ShapeBuilder shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.INTERSECTS);
        return builder;
    }

    public static GeoShapeQueryBuilder geoIntersectionQuery(String name, String indexedShapeId) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId);
        builder.relation(ShapeRelation.INTERSECTS);
        return builder;
    }

    @Deprecated
    public static GeoShapeQueryBuilder geoIntersectionQuery(String name, String indexedShapeId, String indexedShapeType) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId, indexedShapeType);
        builder.relation(ShapeRelation.INTERSECTS);
        return builder;
    }

    public static GeoShapeQueryBuilder geoWithinQuery(String name, Geometry shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.WITHIN);
        return builder;
    }

    @Deprecated
    public static GeoShapeQueryBuilder geoWithinQuery(String name, ShapeBuilder shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.WITHIN);
        return builder;
    }

    public static GeoShapeQueryBuilder geoWithinQuery(String name, String indexedShapeId) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId);
        builder.relation(ShapeRelation.WITHIN);
        return builder;
    }

    @Deprecated
    public static GeoShapeQueryBuilder geoWithinQuery(String name, String indexedShapeId, String indexedShapeType) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId, indexedShapeType);
        builder.relation(ShapeRelation.WITHIN);
        return builder;
    }

    public static GeoShapeQueryBuilder geoDisjointQuery(String name, Geometry shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.DISJOINT);
        return builder;
    }

    @Deprecated
    public static GeoShapeQueryBuilder geoDisjointQuery(String name, ShapeBuilder shape) throws IOException {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, shape);
        builder.relation(ShapeRelation.DISJOINT);
        return builder;
    }

    public static GeoShapeQueryBuilder geoDisjointQuery(String name, String indexedShapeId) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId);
        builder.relation(ShapeRelation.DISJOINT);
        return builder;
    }

    @Deprecated
    public static GeoShapeQueryBuilder geoDisjointQuery(String name, String indexedShapeId, String indexedShapeType) {
        GeoShapeQueryBuilder builder = QueryBuilders.geoShapeQuery(name, indexedShapeId, indexedShapeType);
        builder.relation(ShapeRelation.DISJOINT);
        return builder;
    }

    public static ExistsQueryBuilder existsQuery(String name) {
        return new ExistsQueryBuilder(name);
    }
}

