/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.easysearch.common.ParseField;
import org.easysearch.common.ParsingException;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.query.AbstractQueryBuilder;
import org.easysearch.index.query.QueryBuilder;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.index.query.SpanQueryBuilder;

public class SpanNotQueryBuilder
extends AbstractQueryBuilder<SpanNotQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_not";
    public static final int DEFAULT_PRE = 0;
    public static final int DEFAULT_POST = 0;
    private static final ParseField POST_FIELD = new ParseField("post", new String[0]);
    private static final ParseField PRE_FIELD = new ParseField("pre", new String[0]);
    private static final ParseField DIST_FIELD = new ParseField("dist", new String[0]);
    private static final ParseField EXCLUDE_FIELD = new ParseField("exclude", new String[0]);
    private static final ParseField INCLUDE_FIELD = new ParseField("include", new String[0]);
    private final SpanQueryBuilder include;
    private final SpanQueryBuilder exclude;
    private int pre = 0;
    private int post = 0;

    public SpanNotQueryBuilder(SpanQueryBuilder include, SpanQueryBuilder exclude) {
        if (include == null) {
            throw new IllegalArgumentException("inner clause [include] cannot be null.");
        }
        if (exclude == null) {
            throw new IllegalArgumentException("inner clause [exclude] cannot be null.");
        }
        this.include = include;
        this.exclude = exclude;
    }

    public SpanNotQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.include = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.exclude = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.pre = in.readVInt();
        this.post = in.readVInt();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.include);
        out.writeNamedWriteable(this.exclude);
        out.writeVInt(this.pre);
        out.writeVInt(this.post);
    }

    public SpanQueryBuilder includeQuery() {
        return this.include;
    }

    public SpanQueryBuilder excludeQuery() {
        return this.exclude;
    }

    public SpanNotQueryBuilder dist(int dist) {
        this.pre(dist);
        this.post(dist);
        return this;
    }

    public SpanNotQueryBuilder pre(int pre) {
        this.pre = pre >= 0 ? pre : 0;
        return this;
    }

    public Integer pre() {
        return this.pre;
    }

    public SpanNotQueryBuilder post(int post) {
        this.post = post >= 0 ? post : 0;
        return this;
    }

    public Integer post() {
        return this.post;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(INCLUDE_FIELD.getPreferredName());
        this.include.toXContent(builder, params);
        builder.field(EXCLUDE_FIELD.getPreferredName());
        this.exclude.toXContent(builder, params);
        builder.field(PRE_FIELD.getPreferredName(), this.pre);
        builder.field(POST_FIELD.getPreferredName(), this.post);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static SpanNotQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        SpanQueryBuilder include = null;
        SpanQueryBuilder exclude = null;
        Integer dist = null;
        Integer pre = null;
        Integer post = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                QueryBuilder query;
                if (INCLUDE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    query = SpanNotQueryBuilder.parseInnerQueryBuilder(parser);
                    if (!(query instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "span_not [include] must be of type span query", new Object[0]);
                    }
                    include = (SpanQueryBuilder)query;
                    SpanQueryBuilder.SpanQueryBuilderUtil.checkNoBoost(NAME, currentFieldName, parser, include);
                    continue;
                }
                if (EXCLUDE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    query = SpanNotQueryBuilder.parseInnerQueryBuilder(parser);
                    if (!(query instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "span_not [exclude] must be of type span query", new Object[0]);
                    }
                    exclude = (SpanQueryBuilder)query;
                    SpanQueryBuilder.SpanQueryBuilderUtil.checkNoBoost(NAME, currentFieldName, parser, exclude);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_not] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (DIST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                dist = parser.intValue();
                continue;
            }
            if (PRE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                pre = parser.intValue();
                continue;
            }
            if (POST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                post = parser.intValue();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_not] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (include == null) {
            throw new ParsingException(parser.getTokenLocation(), "span_not must have [include] span query clause", new Object[0]);
        }
        if (exclude == null) {
            throw new ParsingException(parser.getTokenLocation(), "span_not must have [exclude] span query clause", new Object[0]);
        }
        if (dist != null && (pre != null || post != null)) {
            throw new ParsingException(parser.getTokenLocation(), "span_not can either use [dist] or [pre] & [post] (or none)", new Object[0]);
        }
        SpanNotQueryBuilder spanNotQuery = new SpanNotQueryBuilder(include, exclude);
        if (dist != null) {
            spanNotQuery.dist(dist);
        }
        if (pre != null) {
            spanNotQuery.pre(pre);
        }
        if (post != null) {
            spanNotQuery.post(post);
        }
        spanNotQuery.boost(boost);
        spanNotQuery.queryName(queryName);
        return spanNotQuery;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query includeQuery = this.include.toQuery(context);
        assert (includeQuery instanceof SpanQuery);
        Query excludeQuery = this.exclude.toQuery(context);
        assert (excludeQuery instanceof SpanQuery);
        return new SpanNotQuery((SpanQuery)includeQuery, (SpanQuery)excludeQuery, this.pre, this.post);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.include, this.exclude, this.pre, this.post);
    }

    @Override
    protected boolean doEquals(SpanNotQueryBuilder other) {
        return Objects.equals(this.include, other.include) && Objects.equals(this.exclude, other.exclude) && this.pre == other.pre && this.post == other.post;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

