/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.common.ParsingException;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.lucene.search.function.ScoreFunction;
import org.easysearch.common.lucene.search.function.ScriptScoreFunction;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.index.query.QueryShardException;
import org.easysearch.index.query.functionscore.ScoreFunctionBuilder;
import org.easysearch.script.ScoreScript;
import org.easysearch.script.Script;

public class ScriptScoreFunctionBuilder
extends ScoreFunctionBuilder<ScriptScoreFunctionBuilder> {
    public static final String NAME = "script_score";
    private final Script script;

    public ScriptScoreFunctionBuilder(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("script must not be null");
        }
        this.script = script;
    }

    public ScriptScoreFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
    }

    public Script getScript() {
        return this.script;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), this.script);
        builder.endObject();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(ScriptScoreFunctionBuilder functionBuilder) {
        return Objects.equals(this.script, functionBuilder.script);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.script);
    }

    @Override
    protected ScoreFunction doToFunction(QueryShardContext context) {
        try {
            ScoreScript.Factory factory = context.compile(this.script, ScoreScript.CONTEXT);
            ScoreScript.LeafFactory searchScript = factory.newFactory(this.script.getParams(), context.lookup());
            return new ScriptScoreFunction(this.script, searchScript, context.index().getName(), context.getShardId(), context.indexVersionCreated());
        }
        catch (Exception e) {
            throw new QueryShardException(context, "script_score: the script could not be loaded", (Throwable)e, new Object[0]);
        }
    }

    public static ScriptScoreFunctionBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        Script script = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                script = Script.parse(parser);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "script_score query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (script == null) {
            throw new ParsingException(parser.getTokenLocation(), "script_score requires 'script' field", new Object[0]);
        }
        return new ScriptScoreFunctionBuilder(script);
    }
}

