/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.seqno;

import java.io.IOException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.easysearch.ExceptionsHelper;
import org.easysearch.action.ActionListener;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.replication.ReplicationRequest;
import org.easysearch.action.support.replication.ReplicationResponse;
import org.easysearch.action.support.replication.TransportReplicationAction;
import org.easysearch.cluster.action.shard.ShardStateAction;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.util.concurrent.ThreadContext;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.IndexShardClosedException;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.translog.Translog;
import org.easysearch.indices.IndicesService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class GlobalCheckpointSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static String ACTION_NAME = "indices:admin/seq_no/global_checkpoint_sync";

    @Inject
    public GlobalCheckpointSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, x$0 -> new Request(x$0), x$0 -> new Request(x$0), "management");
    }

    public void updateGlobalCheckpointForShard(ShardId shardId) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            this.execute(new Request(shardId), ActionListener.wrap(r -> {}, e -> {
                if (ExceptionsHelper.unwrap(e, AlreadyClosedException.class, IndexShardClosedException.class) == null) {
                    this.logger.info((Message)new ParameterizedMessage("{} global checkpoint sync failed", (Object)shardId), (Throwable)e);
                }
            }));
        }
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard indexShard, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            this.maybeSyncTranslog(indexShard);
            return new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse());
        });
    }

    @Override
    protected void shardOperationOnReplica(Request shardRequest, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            this.maybeSyncTranslog(replica);
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    private void maybeSyncTranslog(IndexShard indexShard) throws IOException {
        if (indexShard.getTranslogDurability() == Translog.Durability.REQUEST && indexShard.getLastSyncedGlobalCheckpoint() < indexShard.getLastKnownGlobalCheckpoint()) {
            indexShard.sync();
        }
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(ShardId shardId) {
            super(shardId);
        }

        @Override
        public String toString() {
            return "GlobalCheckpointSyncAction.Request{shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + "', waitForActiveShards=" + this.waitForActiveShards + "}";
        }
    }
}

