/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.similarity;

import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;

public final class NonNegativeScoresSimilarity
extends Similarity {
    private static final String ES_ENFORCE_POSITIVE_SCORES = "es.enforce.positive.scores";
    private static final boolean ENFORCE_POSITIVE_SCORES;
    private final Similarity in;

    public NonNegativeScoresSimilarity(Similarity in) {
        this.in = in;
    }

    public Similarity getDelegate() {
        return this.in;
    }

    public long computeNorm(FieldInvertState state) {
        return this.in.computeNorm(state);
    }

    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        final Similarity.SimScorer inScorer = this.in.scorer(boost, collectionStats, termStats);
        return new Similarity.SimScorer(){

            public float score(float freq, long norm) {
                float score = inScorer.score(freq, norm);
                if (score < 0.0f) {
                    if (ENFORCE_POSITIVE_SCORES) {
                        throw new IllegalArgumentException("Similarities must not produce negative scores, but got:\n" + inScorer.explain(Explanation.match((Number)Float.valueOf(freq), (String)"term frequency", (Explanation[])new Explanation[0]), norm));
                    }
                    return 0.0f;
                }
                return score;
            }

            public Explanation explain(Explanation freq, long norm) {
                Explanation expl = inScorer.explain(freq, norm);
                if (expl.isMatch() && expl.getValue().floatValue() < 0.0f) {
                    expl = Explanation.match((Number)Float.valueOf(0.0f), (String)"max of:", (Explanation[])new Explanation[]{expl, Explanation.match((Number)Float.valueOf(0.0f), (String)"Minimum allowed score", (Explanation[])new Explanation[0])});
                }
                return expl;
            }
        };
    }

    static {
        String enforcePositiveScores = System.getProperty(ES_ENFORCE_POSITIVE_SCORES);
        if (enforcePositiveScores == null) {
            ENFORCE_POSITIVE_SCORES = true;
        } else if ("false".equals(enforcePositiveScores)) {
            ENFORCE_POSITIVE_SCORES = false;
        } else {
            throw new IllegalArgumentException("es.enforce.positive.scores may only be unset or set to [false], but got [" + enforcePositiveScores + "]");
        }
    }
}

