/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.repositories;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.IndexCommit;
import org.easysearch.Version;
import org.easysearch.action.ActionListener;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.ClusterStateUpdateTask;
import org.easysearch.cluster.metadata.IndexMetadata;
import org.easysearch.cluster.metadata.Metadata;
import org.easysearch.cluster.metadata.RepositoryMetadata;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.Nullable;
import org.easysearch.common.component.LifecycleComponent;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.snapshots.IndexShardSnapshotStatus;
import org.easysearch.index.store.Store;
import org.easysearch.indices.recovery.RecoveryState;
import org.easysearch.repositories.IndexId;
import org.easysearch.repositories.RepositoryData;
import org.easysearch.repositories.RepositoryShardId;
import org.easysearch.repositories.RepositoryStats;
import org.easysearch.repositories.ShardGenerations;
import org.easysearch.snapshots.SnapshotId;
import org.easysearch.snapshots.SnapshotInfo;

public interface Repository
extends LifecycleComponent {
    public RepositoryMetadata getMetadata();

    public SnapshotInfo getSnapshotInfo(SnapshotId var1);

    public Metadata getSnapshotGlobalMetadata(SnapshotId var1);

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData var1, SnapshotId var2, IndexId var3) throws IOException;

    public void getRepositoryData(ActionListener<RepositoryData> var1);

    @Deprecated
    public void initializeSnapshot(SnapshotId var1, List<IndexId> var2, Metadata var3);

    public void finalizeSnapshot(ShardGenerations var1, long var2, Metadata var4, SnapshotInfo var5, Version var6, Function<ClusterState, ClusterState> var7, ActionListener<RepositoryData> var8);

    public void deleteSnapshots(Collection<SnapshotId> var1, long var2, Version var4, ActionListener<RepositoryData> var5);

    public long getSnapshotThrottleTimeInNanos();

    public long getRestoreThrottleTimeInNanos();

    default public RepositoryStats stats() {
        return RepositoryStats.EMPTY_STATS;
    }

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    public void snapshotShard(Store var1, MapperService var2, SnapshotId var3, IndexId var4, IndexCommit var5, @Nullable String var6, IndexShardSnapshotStatus var7, Version var8, Map<String, Object> var9, ActionListener<String> var10);

    public void restoreShard(Store var1, SnapshotId var2, IndexId var3, ShardId var4, RecoveryState var5, ActionListener<Void> var6);

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId var1, IndexId var2, ShardId var3);

    public void updateState(ClusterState var1);

    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> var1, String var2, Consumer<Exception> var3);

    public void cloneShardSnapshot(SnapshotId var1, SnapshotId var2, RepositoryShardId var3, @Nullable String var4, ActionListener<String> var5);

    default public Map<String, Object> adaptUserMetadata(Map<String, Object> userMetadata) {
        return userMetadata;
    }

    public static interface Factory {
        public Repository create(RepositoryMetadata var1) throws Exception;

        default public Repository create(RepositoryMetadata metadata, Function<String, Factory> typeLookup) throws Exception {
            return this.create(metadata);
        }
    }
}

