/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest;

import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.easysearch.EasysearchException;
import org.easysearch.EasysearchStatusException;
import org.easysearch.ExceptionsHelper;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParserUtils;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.RestResponse;
import org.easysearch.rest.RestStatus;

public class BytesRestResponse
extends RestResponse {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private static final String STATUS = "status";
    private static final Logger SUPPRESSED_ERROR_LOGGER = LogManager.getLogger((String)"rest.suppressed");
    private final RestStatus status;
    private final BytesReference content;
    private final String contentType;

    public BytesRestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.contentType().mediaType(), BytesReference.bytes(builder));
    }

    public BytesRestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, String content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, byte[] content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, BytesReference content) {
        this.status = status;
        this.content = content;
        this.contentType = contentType;
    }

    public BytesRestResponse(RestChannel channel, Exception e) throws IOException {
        this(channel, ExceptionsHelper.status(e), e);
    }

    public BytesRestResponse(RestChannel channel, RestStatus status, Exception e) throws IOException {
        ToXContent.Params params = this.paramsFromRequest(channel.request());
        if (params.paramAsBoolean("rest.exception.stacktrace.skip", true) && e != null) {
            Supplier messageSupplier = () -> new ParameterizedMessage("path: {}, params: {}", (Object)channel.request().rawPath(), channel.request().params());
            if (status.getStatus() < 500) {
                SUPPRESSED_ERROR_LOGGER.debug(messageSupplier, (Throwable)e);
            } else {
                SUPPRESSED_ERROR_LOGGER.warn(messageSupplier, (Throwable)e);
            }
        }
        this.status = status;
        try (XContentBuilder builder = channel.newErrorBuilder();){
            this.build(builder, params, status, channel.detailedErrorsEnabled(), e);
            this.content = BytesReference.bytes(builder);
            this.contentType = builder.contentType().mediaType();
        }
        if (e instanceof EasysearchException) {
            this.copyHeaders((EasysearchException)e);
        }
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    private ToXContent.Params paramsFromRequest(RestRequest restRequest) {
        ToXContent.Params params = restRequest;
        if (params.paramAsBoolean("error_trace", false) && !this.skipStackTrace()) {
            params = new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"), params);
        }
        return params;
    }

    protected boolean skipStackTrace() {
        return false;
    }

    private void build(XContentBuilder builder, ToXContent.Params params, RestStatus status, boolean detailedErrorsEnabled, Exception e) throws IOException {
        builder.startObject();
        EasysearchException.generateFailureXContent(builder, params, e, detailedErrorsEnabled);
        builder.field(STATUS, status.getStatus());
        builder.endObject();
    }

    static BytesRestResponse createSimpleErrorResponse(RestChannel channel, RestStatus status, String errorMessage) throws IOException {
        return new BytesRestResponse(status, channel.newErrorBuilder().startObject().field("error", errorMessage).field(STATUS, status.getStatus()).endObject());
    }

    public static EasysearchStatusException errorFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        Throwable exception = null;
        RestStatus status = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            }
            if (STATUS.equals(currentFieldName)) {
                if (token == XContentParser.Token.FIELD_NAME) continue;
                if (XContentParser.Token.VALUE_NUMBER == token) {
                    status = RestStatus.fromCode(parser.intValue());
                    continue;
                }
                status = RestStatus.valueOf(parser.text());
                continue;
            }
            exception = EasysearchException.failureFromXContent2(parser);
        }
        if (exception == null) {
            throw new IllegalStateException("Failed to parse easysearch status exception: no exception was found");
        }
        EasysearchStatusException result = new EasysearchStatusException(exception.getMessage(), status, exception.getCause(), new Object[0]);
        for (String header : ((EasysearchException)exception).getHeaderKeys()) {
            result.addHeader(header, ((EasysearchException)exception).getHeader(header));
        }
        for (String metadata : ((EasysearchException)exception).getMetadataKeys()) {
            result.addMetadata(metadata, ((EasysearchException)exception).getMetadata(metadata));
        }
        return result;
    }
}

