/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.easysearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.easysearch.client.Requests;
import org.easysearch.client.node.NodeClient;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestToXContentListener;

public class RestRestoreSnapshotAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_snapshot/{repository}/{snapshot}/_restore"));
    }

    @Override
    public String getName() {
        return "restore_snapshot_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        RestoreSnapshotRequest restoreSnapshotRequest = Requests.restoreSnapshotRequest(request.param("repository"), request.param("snapshot"));
        restoreSnapshotRequest.masterNodeTimeout(request.paramAsTime("master_timeout", restoreSnapshotRequest.masterNodeTimeout()));
        restoreSnapshotRequest.waitForCompletion(request.paramAsBoolean("wait_for_completion", false));
        request.applyContentParser(p -> restoreSnapshotRequest.source(p.mapOrdered()));
        return channel -> client.admin().cluster().restoreSnapshot(restoreSnapshotRequest, new RestToXContentListener<RestoreSnapshotResponse>((RestChannel)channel));
    }
}

