/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.flush.SyncedFlushRequest;
import org.easysearch.action.admin.indices.flush.SyncedFlushResponse;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Strings;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.BytesRestResponse;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.RestResponse;
import org.easysearch.rest.action.RestBuilderListener;

public class RestSyncedFlushAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_flush/synced"), new RestHandler.Route(RestRequest.Method.POST, "/_flush/synced"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_flush/synced"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_flush/synced")));
    }

    @Override
    public String getName() {
        return "synced_flush_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        IndicesOptions indicesOptions = IndicesOptions.fromRequest(request, IndicesOptions.lenientExpandOpen());
        SyncedFlushRequest syncedFlushRequest = new SyncedFlushRequest(Strings.splitStringByCommaToArray(request.param("index")));
        syncedFlushRequest.indicesOptions(indicesOptions);
        return channel -> client.admin().indices().syncedFlush(syncedFlushRequest, (ActionListener<SyncedFlushResponse>)new RestBuilderListener<SyncedFlushResponse>(channel){

            @Override
            public RestResponse buildResponse(SyncedFlushResponse results, XContentBuilder builder) throws Exception {
                builder.startObject();
                results.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(results.restStatus(), builder);
            }
        });
    }
}

